/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.BlameAssertions;
import com.cenqua.fisheye.util.SumMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.mockito.Mockito;

public class BlameAssertionsTest {
    @Test
    public void testAssertFirstBlameChunkStartsAt0WhenItDoes() throws Exception {
        BlameAssertions.assertBlameStartsAt0((List)ImmutableList.of());
        BlameAssertions.assertBlameStartsAt0((List)ImmutableList.of((Object)new BlameChunk(0, 0, 1, 1)));
        BlameAssertions.assertBlameStartsAt0((List)ImmutableList.of((Object)new BlameChunk(0, 0, 1, 1), (Object)new BlameChunk(1, 0, 1, 2)));
    }

    @Test(expected=AuthorBlameException.class)
    public void testAssertFirstBlameChunkStartsAt0WhenItDoesNot() throws Exception {
        BlameAssertions.assertBlameStartsAt0((List)ImmutableList.of((Object)new BlameChunk(1, 0, 1, 1)));
    }

    @Test
    public void testAssertBlameChunksAreConsecutiveWhenTheyAre() throws Exception {
        BlameAssertions.assertBlameChunksAreConsecutive((List)ImmutableList.of());
        BlameAssertions.assertBlameChunksAreConsecutive((List)ImmutableList.of((Object)new BlameChunk(0, 0, 1, 1)));
        BlameAssertions.assertBlameChunksAreConsecutive((List)ImmutableList.of((Object)new BlameChunk(0, 0, 1, 1), (Object)new BlameChunk(1, 0, 1, 2)));
    }

    @Test(expected=AuthorBlameException.class)
    public void testAssertBlameChunksAreConsecutiveWhenTheyAreNot() throws Exception {
        BlameAssertions.assertBlameChunksAreConsecutive((List)ImmutableList.of((Object)new BlameChunk(0, 0, 1, 1), (Object)new BlameChunk(2, 0, 1, 2)));
    }

    @Test
    public void testAssertNoBlameLinesAreNegativeWhenTheyAreNot() throws Exception {
        BlameAssertions.assertNoBlameLinesAreNegative(null, this.newSumMap((Map<String, Integer>)ImmutableMap.of()));
        BlameAssertions.assertNoBlameLinesAreNegative(null, this.newSumMap((Map<String, Integer>)ImmutableMap.of((Object)"foo", (Object)3, (Object)"bar", (Object)0)));
    }

    @Test(expected=AuthorBlameException.class)
    public void testAssertNoBlameLinesAreNegativeWhenTheyAre() throws Exception {
        BlameAssertions.assertNoBlameLinesAreNegative(null, this.newSumMap((Map<String, Integer>)ImmutableMap.of((Object)"foo", (Object)3, (Object)"naughty", (Object)-1)));
    }

    private SumMap<String> newSumMap(Map<String, Integer> input) {
        SumMap instance = SumMap.getInstance();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            instance.addValue((Object)entry.getKey(), entry.getValue().intValue());
        }
        return instance;
    }

    @Test
    public void testAssertBlameLinesEqualRevisionLinesWhenTheyDo() throws Exception {
        this.testAssertBlameLinesEqualRevisionLines(42, 42);
    }

    @Test(expected=AuthorBlameException.class)
    public void testAssertBlameLinesEqualRevisionLinesWhenTheyDoNot() throws Exception {
        this.testAssertBlameLinesEqualRevisionLines(42, 13);
    }

    private void testAssertBlameLinesEqualRevisionLines(int revLineCount, int blameLineCount) throws AuthorBlameException {
        FileRevision fileRevision = (FileRevision)Mockito.mock(FileRevision.class);
        Mockito.when((Object)fileRevision.getLineCount()).thenReturn((Object)revLineCount);
        Blame blame = new Blame((List)ImmutableList.of((Object)new BlameChunk(0, 0, blameLineCount, 100)));
        BlameAssertions.assertBlameLinesEqualRevisionLines((FileRevision)fileRevision, (Blame)blame);
    }
}

