/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.NullLogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.blame.BaseBlameAndLinecountCalculator;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseBlameAndLinecountCalculatorTest {
    BaseBlameAndLinecountCalculator calculator;
    @Mock
    RepositoryEngine engine;
    @Mock
    InternalRevisionCache cache;
    @Mock
    BucketGraph bucketGraph;
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule(Level.DEBUG);
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.engine.getInternalRevisionCache()).thenReturn((Object)this.cache);
        Mockito.when((Object)this.cache.isStoreDiffs()).thenReturn((Object)true);
        Mockito.when((Object)this.engine.getBucketGraph()).thenReturn((Object)this.bucketGraph);
        Mockito.when((Object)this.engine.getPathMatcher()).thenReturn((Object)new NullLogicalPathMatcher());
        Mockito.when((Object)this.bucketGraph.getTimeZone()).thenReturn((Object)TimeZone.getTimeZone("GMT"));
        this.calculator = new BaseBlameAndLinecountCalculator(this.engine);
    }

    @Test
    public void shouldSkipBlameForAlreadyIndexedRevisions() throws Exception {
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)this.cache.hasBlameSpans(rev.getRevInfoKey())).thenReturn((Object)true);
        Mockito.when((Object)this.cache.getFileRevision(12)).thenReturn((Object)rev);
        this.calculator.calculateAndStoreRevisionData(12, false);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.never())).setBlameSpans((RevInfoKey)org.mockito.Matchers.eq((Object)rev.getRevInfoKey()), (List)org.mockito.Matchers.any(List.class));
    }

    @Test
    public void shouldRecalculateBlameForAlreadyIndexedRevisionsIfForced() throws Exception {
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)this.cache.getFileRevision(12)).thenReturn((Object)rev);
        this.calculator.calculateAndStoreRevisionData(12, true);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.never())).hasBlameSpans(rev.getRevInfoKey());
        ((InternalRevisionCache)Mockito.verify((Object)this.cache)).setBlameSpans(rev.getRevInfoKey(), Collections.emptyList());
    }

    @Test
    public void shouldCalculateBlameForAdditions() throws Exception {
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        int revId = 13;
        Mockito.when((Object)rev.getLineCount()).thenReturn((Object)5);
        Mockito.when((Object)rev.getLinesAdded()).thenReturn((Object)5);
        Mockito.when((Object)rev.getAuthor()).thenReturn((Object)"author");
        Mockito.when((Object)rev.getRevID()).thenReturn((Object)13);
        Mockito.when((Object)this.cache.getFileRevision(13)).thenReturn((Object)rev);
        this.calculator.calculateAndStoreRevisionData(13, false);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache)).setBlameSpans(rev.getRevInfoKey(), Collections.singletonList(new BlameChunk(0, 0, 5, 13)));
    }

    @Test
    public void shouldStoreBlameSpansForDeletions() throws Exception {
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)rev.getAncestors()).thenReturn(Collections.emptyList());
        Mockito.when((Object)rev.isDead()).thenReturn((Object)true);
        this.calculator.calcBlame(rev);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache)).setBlameSpans(rev.getRevInfoKey(), Collections.emptyList());
    }

    @Test
    public void calcWhenFlagExplicitlyEnabledBlameShouldFallbackToScmOnErrors() throws Exception {
        System.setProperty("fisheye.blame.scm.fallback.enable", "true");
        FishEyeSysProps.reloadProperties();
        Blame fallbackBlame = new Blame();
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)rev.getLinesRemoved()).thenReturn((Object)-1);
        Mockito.when((Object)this.cache.getBlame(rev.getDiffRevision(), false)).thenReturn(Optional.of(new Blame()));
        Mockito.when((Object)this.cache.getBlameFallback(rev.getRevInfoKey())).thenReturn((Object)fallbackBlame);
        this.calculator.calcBlame(rev);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache)).setBlameSpans((RevInfoKey)org.mockito.Matchers.eq((Object)rev.getRevInfoKey()), (List)org.mockito.Matchers.same((Object)fallbackBlame.getChunks()));
        Assert.assertThat(this.logs.getEvents(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.DEBUG), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("Problems calculating blame for a.txt@1, will fetch from repository instead"))));
    }

    @Test
    public void calcBlameShouldNotFallbackToScmOnErrorsIfDisabled() throws Exception {
        System.setProperty("fisheye.blame.scm.fallback.enable", "false");
        FishEyeSysProps.reloadProperties();
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)rev.getLinesRemoved()).thenReturn((Object)-1);
        this.calculator.calcBlame(rev);
        ((InternalRevisionCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.never())).getBlameFallback((RevInfoKey)org.mockito.Matchers.any(RevInfoKey.class));
        Assert.assertThat(this.logs.getEvents(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.DEBUG), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("Problems calculating blame for a.txt@1, blame won't be calculated"))));
    }

    @Test
    public void shouldGetRevisionCacheLazily() throws Exception {
        FileRevision rev = FisheyeTestUtil.mockRevision("1", "a.txt");
        Mockito.when((Object)this.cache.getBlame(rev.getRevInfoKey(), false)).thenReturn(Optional.of(new Blame((List)ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1)))));
        Mockito.when((Object)this.engine.getInternalRevisionCache()).thenReturn(null);
        this.calculator = new BaseBlameAndLinecountCalculator(this.engine);
        ((RepositoryEngine)Mockito.verify((Object)this.engine, (VerificationMode)Mockito.never())).getInternalRevisionCache();
        Mockito.when((Object)this.engine.getInternalRevisionCache()).thenReturn((Object)this.cache);
        this.calculator.getHistory(rev.getRevInfoKey());
        ((RepositoryEngine)Mockito.verify((Object)this.engine, (VerificationMode)Mockito.atLeastOnce())).getInternalRevisionCache();
    }
}

