/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.blame.BaseBlameAndLinecountCalculator;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseBlameAndLinecountCalculatorApplyHunksTest {
    private static final String GIT_BLAME_FILE = "gitBlameBuildXml.txt";
    private static final String GIT_LOG_FILE = "gitLogBuildXml.txt";
    private BaseBlameAndLinecountCalculator baseBlameAndLinecountCalculator;

    @Before
    public void setUp() throws Exception {
        this.baseBlameAndLinecountCalculator = new BaseBlameAndLinecountCalculator((RepositoryEngine)Mockito.mock(RepositoryEngine.class));
    }

    @Test
    public void testBasedOnARealGitFile() throws Exception {
        List blameChunks = Collections.emptyList();
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(0, 1, 0, 4)), 7);
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(1, 0, 2, 0)), 311);
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(2, 3, 0, 3)), 8);
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(1, 2, 0, 2), (Object)new Hunk(3, 6, 0, 5), (Object)new Hunk(5, 11, 1, 0)), 3);
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(1, 0, 2, 0), (Object)new Hunk(5, 3, 2, 2), (Object)new Hunk(9, 7, 1, 1)), 0);
        blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, (List)ImmutableList.of((Object)new Hunk(0, 1, 0, 1)), 6);
        Assert.assertEquals((Object)"[0-1:6, 1-2:3, 2-3:7, 3-5:0, 5-7:3, 7-8:0, 8-9:3, 9-10:8]", (Object)blameChunks.toString());
    }

    @Test
    public void testRealGitFileBuildXml() throws Exception {
        List logItems = GitLogParser.parseGitLogToHunkData(GIT_LOG_FILE);
        List blames = GitBlameParser.parseBlame(GIT_BLAME_FILE);
        List blameChunks = Collections.emptyList();
        for (GitLogParser.LogItem logItem : logItems) {
            blameChunks = this.baseBlameAndLinecountCalculator.applyHunks(blameChunks, logItem.hunkData.stream().map(hd -> new Hunk(((GitLogParser.HunkData)hd).from, ((GitLogParser.HunkData)hd).to, ((GitLogParser.HunkData)hd).fromCount, ((GitLogParser.HunkData)hd).toCount)).collect(Collectors.toList()), BaseBlameAndLinecountCalculatorApplyHunksTest.shortHashToInt(logItem.shortHash));
        }
        Iterator expectedIterator = blames.iterator();
        Iterator actualIterator = blameChunks.iterator();
        while (expectedIterator.hasNext()) {
            GitBlameParser.BlameChunkData expected = (GitBlameParser.BlameChunkData)expectedIterator.next();
            BlameChunk actual = (BlameChunk)actualIterator.next();
            Assert.assertEquals((Object)(expected.start + "-" + (expected.start + expected.length) + ":" + BaseBlameAndLinecountCalculatorApplyHunksTest.shortHashToInt(expected.shortHash)), (Object)actual.toString());
        }
        Assert.assertEquals((String)"should be nothing left", Collections.emptyList(), (Object)Lists.newArrayList(actualIterator));
    }

    private static int shortHashToInt(String shortHash) {
        return (int)((double)Long.parseLong(shortHash, 16) % 1.0E9);
    }

    private static String[] readAllLinesFromClasspathFile(String filePath) throws IOException {
        URL resource = Resources.getResource(BaseBlameAndLinecountCalculatorApplyHunksTest.class, (String)("data/" + filePath));
        String fileLines = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        return fileLines.split("\n");
    }

    private static class GitBlameParser {
        private GitBlameParser() {
        }

        private static List<BlameChunkData> parseBlame(String gitBlameFile) throws Exception {
            String[] lines = BaseBlameAndLinecountCalculatorApplyHunksTest.readAllLinesFromClasspathFile(gitBlameFile);
            LinkedList<BlameChunkData> blameChunkData = new LinkedList<BlameChunkData>();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String shortHash = line.charAt(0) == '^' ? line.substring(1, 9) : line.substring(0, 8);
                BlameChunkData prev = blameChunkData.peekLast();
                if (prev != null && prev.shortHash.equals(shortHash)) {
                    prev.length++;
                    continue;
                }
                blameChunkData.add(new BlameChunkData(i, shortHash));
            }
            return blameChunkData;
        }

        private static class BlameChunkData {
            private final int start;
            private int length;
            private final String shortHash;

            private BlameChunkData(int start, String shortHash) {
                this.start = start;
                this.shortHash = shortHash;
                this.length = 1;
            }
        }
    }

    private static class GitLogParser {
        private static final Pattern HUNK_PATTERN = Pattern.compile("@@ -(\\d+)(?:,(\\d+))? \\+(\\d+)(?:,(\\d+))? @@.*");

        private GitLogParser() {
        }

        private static List<LogItem> parseGitLogToHunkData(String gitLogFile) throws Exception {
            String[] lines = BaseBlameAndLinecountCalculatorApplyHunksTest.readAllLinesFromClasspathFile(gitLogFile);
            ArrayList<LogItem> logItems = new ArrayList<LogItem>();
            LogItem currentLogItem = null;
            for (String line : lines) {
                if (line.startsWith("commit ")) {
                    String shortHash = line.substring(7, 15);
                    currentLogItem = new LogItem(shortHash);
                    logItems.add(currentLogItem);
                    continue;
                }
                if (line.startsWith("@@ ")) {
                    Matcher matcher = HUNK_PATTERN.matcher(line);
                    matcher.matches();
                    currentLogItem.addHunkData(new HunkData(GitLogParser.getValueOr1(matcher, 1), GitLogParser.getValueOr1(matcher, 2), GitLogParser.getValueOr1(matcher, 3), GitLogParser.getValueOr1(matcher, 4)));
                    continue;
                }
                if (!line.startsWith("Merge: ")) continue;
                throw new UnsupportedOperationException("Current blame calculation does not support merges. Restrict the log and blame files to revisions earlier than " + currentLogItem.shortHash);
            }
            return logItems;
        }

        private static int getValueOr1(Matcher matcher, int i) {
            String value = matcher.group(i);
            return value != null ? Integer.parseInt(value) : 1;
        }

        private static class HunkData {
            private final int from;
            private final int fromCount;
            private final int to;
            private final int toCount;

            private HunkData(int from, int fromCount, int to, int toCount) {
                this.from = from;
                this.fromCount = fromCount;
                this.to = to;
                this.toCount = toCount;
            }
        }

        private static class LogItem {
            private final String shortHash;
            private final List<HunkData> hunkData = new ArrayList<HunkData>();

            private LogItem(String shortHash) {
                this.shortHash = shortHash;
            }

            private void addHunkData(HunkData data) {
                this.hunkData.add(data);
            }
        }
    }
}

