/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.blame.AuthorLinesCalculator;
import com.cenqua.fisheye.rep.blame.RevIdToAuthorMap;
import com.cenqua.fisheye.util.SumMap;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorLinesCalculatorTest {
    private static final int ANY_NUMBER = -1;
    private AuthorLinesCalculator authorLinesCalculator;

    @Before
    public void setUp() throws Exception {
        this.authorLinesCalculator = new AuthorLinesCalculator(new RevIdToAuthorMap(){
            Int2ObjectMap<String> revIdToAuthor = new Int2ObjectOpenHashMap();
            {
                this.revIdToAuthor.put(1, (Object)"A");
                this.revIdToAuthor.put(2, (Object)"B");
                this.revIdToAuthor.put(3, (Object)"A");
                this.revIdToAuthor.put(4, (Object)"A");
            }

            public Optional<String> getAuthor(int revId) {
                String author = (String)this.revIdToAuthor.get(revId);
                return Optional.fromNullable((Object)author);
            }
        });
    }

    @Test
    public void testEmptyListOfBlames() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        SumMap actual = this.authorLinesCalculator.getAuthorLinecount((List)blameChunks);
        Assert.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void testZeroLengthBlames() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, -1, 0, 1), (Object)new BlameChunk(0, -1, 0, 2));
        SumMap actual = this.authorLinesCalculator.getAuthorLinecount((List)blameChunks);
        Assert.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void testSingleBlameChunkPerAuthor() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, -1, 4, 1), (Object)new BlameChunk(4, -1, 12, 2));
        SumMap actual = this.authorLinesCalculator.getAuthorLinecount((List)blameChunks);
        Assert.assertEquals((Object)"{B=>12, A=>4}", (Object)actual.toString());
    }

    @Test
    public void testMultipleBlameChunksPerAuthor() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, -1, 4, 1), (Object)new BlameChunk(4, -1, 12, 2), (Object)new BlameChunk(16, -1, 3, 3), (Object)new BlameChunk(19, -1, 1, 2), (Object)new BlameChunk(20, -1, 8, 4));
        SumMap actual = this.authorLinesCalculator.getAuthorLinecount((List)blameChunks);
        Assert.assertEquals((Object)"{B=>13, A=>15}", (Object)actual.toString());
    }

    @Test
    public void testUnknownAuthor() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, -1, 4, 1), (Object)new BlameChunk(4, -1, 7, -1), (Object)new BlameChunk(11, -1, 2, 3), (Object)new BlameChunk(13, -1, 5, 13));
        SumMap actual = this.authorLinesCalculator.getAuthorLinecount((List)blameChunks);
        Assert.assertEquals((Object)"{A=>6}", (Object)actual.toString());
    }
}

