/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.Version;
import junit.framework.TestCase;

public class VersionTest
extends TestCase {
    public void testStringConstructor() {
        Version expected = new Version("1.0.1.8");
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1-0-1-8"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8alpha"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8-beta"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1-8"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8-SNAPSHOT"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8-RC2"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8-RC-2"));
        VersionTest.assertEquals((Object)expected, (Object)new Version("1.0.1.8+20100601"));
    }

    public void testCompareVersions() {
        Version ver102 = new Version("1.0.2");
        VersionTest.assertEquals((int)0, (int)ver102.compareTo(new Version("1.0.2")));
        VersionTest.assertTrue((ver102.compareTo(new Version("1.0.3")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("10.1")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("2.0.1")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("1.0.2.1")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("1.0.19")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("1.1.0")) < 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("1.0.1.99")) > 0 ? 1 : 0) != 0);
        VersionTest.assertTrue((ver102.compareTo(new Version("0.0.3")) > 0 ? 1 : 0) != 0);
    }

    public void testToString() {
        VersionTest.assertEquals((String)"1.0.1", (String)new Version("1.0.1").toString());
        VersionTest.assertEquals((String)"1.0.1", (String)new Version("1.0.1-alpha").toString());
        VersionTest.assertEquals((String)"1.0.1", (String)new Version("1.0.1beta").toString());
        VersionTest.assertEquals((String)"1.0.1", (String)new Version("1.0.1-RC4").toString());
        VersionTest.assertEquals((String)"1.0.1", (String)new Version("1-0-1#20100501").toString());
    }
}

