/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.VersionHandler;
import junit.framework.TestCase;

public class VersionHandlerTest
extends TestCase {
    public void testSingleLine() {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.-]+)");
        handler.processLine(0, "This is the first line with a version 1.2.4 in it");
        VersionHandlerTest.assertNotNull((Object)handler.getVersionString());
        VersionHandlerTest.assertEquals((String)"1.2.4", (String)handler.getVersionString());
    }

    public void testMultiLine() {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.-]+)");
        handler.processLine(0, "This is the first line with a version 1.2.4 in it");
        handler.processLine(1, "This is the second line with another version 1.2.8 in it");
        VersionHandlerTest.assertNotNull((Object)handler.getVersionString());
        VersionHandlerTest.assertEquals((String)"1.2.4", (String)handler.getVersionString());
    }

    public void testMultiLine2() {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.-]+)");
        handler.processLine(0, "This is the first line without a version in it");
        handler.processLine(1, "This is the second line with another version 1.2.8 in it");
        VersionHandlerTest.assertNotNull((Object)handler.getVersionString());
        VersionHandlerTest.assertEquals((String)"1.2.8", (String)handler.getVersionString());
    }

    public void testHgVersion() {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.\\+]+)");
        handler.processLine(0, "Mercurial Distributed SCM (version 1.5.4+20100601)");
        handler.processLine(1, "");
        handler.processLine(2, "Copyright (C) 2005-2010 Matt Mackall <mpm@selenic.com> and others");
        handler.processLine(3, "This is free software; see the source for copying conditions. There is NO");
        handler.processLine(4, "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
        VersionHandlerTest.assertNotNull((Object)handler.getVersionString());
        VersionHandlerTest.assertEquals((String)"1.5.4+20100601", (String)handler.getVersionString());
    }
}

