/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.fisheye.plugin.DelegatingFisheyePluginManager;
import com.cenqua.crucible.helpers.TestDbControlFactory;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.PermissionManagerTestUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.LegacyRepositoryManagerRootConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.ctl.Run;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.FisheyeContextLoader;
import com.cenqua.fisheye.web.WebServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.util.ReflectionUtils;

public class TestFishEyeInstances {
    private static Logger log = Logger.getLogger(TestFishEyeInstances.class);
    private static final String SANITY_APP_CONTEXT = "classpath:com/cenqua/fisheye/rep/sanityTestApplicationContext.xml";
    private static Throwable sanity1Loader = null;
    private static List<Throwable> sanity1LaterLoaders = new ArrayList<Throwable>();
    private static boolean sanity1loaded = false;
    private static WebServer ws;
    private static DBControlFactory dbControlFactory;

    public static DBControl createTesHSQLController(File dbdir) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.HSQL);
        if (dbdir == null) {
            try {
                dbdir = FisheyeTestUtil.createTempDir("fetestdb");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        log.info((Object)("Creating HSQL db in directory " + dbdir.getAbsolutePath()));
        dbconfig.setJdbcURL("jdbc:hsqldb:file:" + dbdir.getAbsolutePath());
        dbconfig.setPassword("");
        dbconfig.setUsername("sa");
        dbconfig.setParam("hsqldb.default_table_type", "memory");
        dbconfig.setParam("hsqldb.log_size", "100");
        dbconfig.setGenerateStatistics(true);
        return DefaultDBControl.newInstance((DatabaseConfig)dbconfig, (File)new File(FisheyeTestEnv.WORKSPACE_DIR, "output/dist/sql"));
    }

    public static DBControlFactory getDBControlFactory() {
        if (dbControlFactory == null) {
            dbControlFactory = new DBControlFactoryImpl(AppConfig.getInstanceDir(), TestDbControlFactory.SQL_SCRIPT_BASE_DIR);
            dbControlFactory.setCurrentControl(TestFishEyeInstances.createTesHSQLController(null));
        }
        return dbControlFactory;
    }

    public static RepositoryHandle getSanity1Repos() throws Exception {
        return TestFishEyeInstances.getSanity1Repos(true);
    }

    public static RepositoryHandle getSanity1Repos(boolean loadCruDb) throws Exception {
        TestFishEyeInstances.loadSanity1(loadCruDb);
        return AppConfig.getsConfig().getRepositoryManager().getRepository("cvs");
    }

    public static RepositoryHandle reslurpAndGetSanity1Repos2() throws Exception {
        TestFishEyeInstances.loadSanity1();
        RepositoryManager repositoryManager = AppConfig.getsConfig().getRepositoryManager();
        RepositoryHandle rep = repositoryManager.getRepository("cvs2");
        if (!rep.isStopped() && !rep.tryStop(5000L)) {
            throw new Exception("could not stop repository");
        }
        File cachedir = new File(TestFishEyeInstances.getSanity1Dir(), "var/cache/cvs2");
        IOHelper.recursiveDelete((File)cachedir, (int)4);
        cachedir.delete();
        repositoryManager.runRepository(rep.getName());
        TestFishEyeInstances.advanceSanity1Repos2(0);
        return rep;
    }

    public static RepositoryHandle getSanity1SvnRepo() throws Exception {
        TestFishEyeInstances.loadSanity1();
        return AppConfig.getsConfig().getRepositoryManager().getRepository("svn");
    }

    public static RepositoryHandle getSanity1SvnPropsRepo() throws Exception {
        TestFishEyeInstances.loadSanity1();
        return AppConfig.getsConfig().getRepositoryManager().getRepository("svnprops");
    }

    public static void advanceSanity1Repos2(int stage) throws Exception {
        System.out.println("ADVANCING TO STAGE " + stage);
        Thread.sleep(2100L);
        RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository("cvs2");
        File cvsdir = new File(FisheyeTestUtil.getTmpDir(), "sanity1-cvs2");
        TestFishEyeInstances.advanceSanity1Repos2(stage, cvsdir);
        TestFishEyeInstances.fullslurp(rep);
    }

    private static void advanceSanity1Repos2(int stage, File dir) throws Exception {
        File[] children;
        String suffix = "-" + stage;
        for (File child : children = dir.listFiles()) {
            if (child.isDirectory()) {
                TestFishEyeInstances.advanceSanity1Repos2(stage, child);
                continue;
            }
            String name = child.getName();
            if (!name.endsWith(suffix)) continue;
            File dest = new File(dir, name.substring(0, name.length() - suffix.length()));
            dest.delete();
            IOHelper.copy((File)child, (File)dest);
            System.out.println(" copied " + child + " to " + dest);
        }
    }

    public static void setupSanity1AppConfig() {
        File sanity1Dir = TestFishEyeInstances.getSanity1Dir();
        AppConfig.overrideAppHome((File)new File(FisheyeTestEnv.WORKSPACE_DIR, "output/dist"), (File)sanity1Dir);
    }

    public static RootConfig loadSanity1RootConfig() throws XmlException, LicenseException, ConfigException, IOException, DbException {
        return TestFishEyeInstances.loadConfigFromFile("sanity1-config.xml");
    }

    public static void loadSanity1() throws Exception {
        TestFishEyeInstances.loadSanity1(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSanity1(boolean withCruDB) throws Exception {
        try {
            TestFishEyeInstances.setupSanity1AppConfig();
            if (sanity1loaded) {
                sanity1LaterLoaders.add(new Throwable("asked to load when already started"));
                TestFishEyeInstances.restartRepositories();
                return;
            }
            RootConfig rc = TestFishEyeInstances.loadConfigFromFile("sanity1-config.xml");
            ws = new WebServer();
            AppConfig.setWebServer((WebServer)ws);
            if (withCruDB) {
                TestFishEyeInstances.getDBControlFactory().getCurrentControl().start();
            }
            DelegatingFisheyePluginManager.startOsgi = false;
            TestFishEyeInstances.startWebServer();
            if (withCruDB) {
                HibernateUtil.beginTransaction();
                PermissionManagerTestUtil.checkAndCreateDefaultPS((CurrentSessionProvider)SpringContext.getComponentByClass(CurrentSessionProvider.class), (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class));
                HibernateUtil.commitTransaction();
                HibernateUtil.closeSession();
            }
            RepositoryManager repositoryManager = rc.getRepositoryManager();
            for (RepositoryHandle rep : repositoryManager.getHandles()) {
                rep.setDisableBackgroundUpdaterOnInit(true);
            }
            rc.startRepositories();
            DefaultReviewItemIndexer.doStart();
            Disposer.pushThreadInstance();
            try {
                for (RepositoryHandle rep : repositoryManager.getHandles()) {
                    TestFishEyeInstances.fullslurp(rep);
                }
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
        catch (Exception e) {
            try {
                TestFishEyeInstances.stop();
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"Problem when trying to stop test instances", (Throwable)e2);
            }
            throw e;
        }
        sanity1loaded = true;
        sanity1Loader = new Throwable("loading sanity1");
    }

    private static boolean maybeSetSanityAppContextResources() {
        if (FisheyeContextLoader.contextConfigurationResources == null) {
            FisheyeContextLoader.contextConfigurationResources = "WEB-INF/applicationContext.xml;WEB-INF/productionApplicationContext.xml;classpath:com/cenqua/fisheye/rep/sanityTestApplicationContext.xml";
            return true;
        }
        return false;
    }

    private static void resetAppContextResources() {
        FisheyeContextLoader.contextConfigurationResources = null;
    }

    public static void loadWebOnlySanity() throws Exception {
        TestFishEyeInstances.loadWebOnlySanity(true);
    }

    public static void loadWebOnlySanity(boolean startCruDB) throws Exception {
        TestFishEyeInstances.setupSanity1AppConfig();
        RootConfig rc = TestFishEyeInstances.loadConfigFromFile("sanity1-config.xml");
        ws = new WebServer();
        AppConfig.setWebServer((WebServer)ws);
        if (startCruDB) {
            TestFishEyeInstances.getDBControlFactory().getCurrentControl().start();
        }
        TestFishEyeInstances.startWebServer();
        RepositoryManager repositoryManager = rc.getRepositoryManager();
        for (RepositoryHandle rep : repositoryManager.getHandles()) {
            rep.setDisableBackgroundUpdaterOnInit(true);
        }
    }

    private static void startWebServer() throws Exception {
        boolean didChangeAppContextConfig = false;
        boolean started = false;
        try {
            didChangeAppContextConfig = TestFishEyeInstances.maybeSetSanityAppContextResources();
            ws.start();
            started = true;
        }
        finally {
            if (didChangeAppContextConfig) {
                TestFishEyeInstances.resetAppContextResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RootConfig loadConfigFromFile(String configFilename) throws IOException, XmlException, ConfigException, LicenseException, DbException {
        LegacyRepositoryManagerRootConfig rc = LegacyRepositoryManagerRootConfig.resetConfig();
        InputStream in = null;
        ConfigDocument cfgd = null;
        try {
            in = RepSanityTestBase.class.getResourceAsStream(configFilename);
            cfgd = TestFishEyeInstances.loadConfigDocumentFromStream(in);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{in});
        rc.load(cfgd);
        rc.loadLicense();
        rc.start();
        return rc;
    }

    public static void checkCleanStart() {
        if (sanity1Loader != null) {
            System.out.println("*** Sanity loaded via:-");
            sanity1Loader.printStackTrace(System.out);
        }
        TestCase.assertTrue((String)"Webserver set", (AppConfig.getWebServer() == null ? 1 : 0) != 0);
        TestFishEyeInstances.assertSanity1Closed();
    }

    private static StackTraceElement getTestCaller(Throwable trace) {
        if (trace == null) {
            return null;
        }
        boolean found = false;
        int index = 0;
        while (!found && index < trace.getStackTrace().length) {
            StackTraceElement stackElement = trace.getStackTrace()[index];
            try {
                String classname = stackElement.getClassName();
                if (!classname.equals(TestFishEyeInstances.class.getName()) && classname.endsWith("Test")) {
                    Class<?> callerClass = Class.forName(classname);
                    boolean bl = found = !Modifier.isAbstract(callerClass.getModifiers());
                }
                if (found) continue;
                ++index;
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        if (found) {
            return trace.getStackTrace()[index];
        }
        System.out.println("Unable to determine Test case for " + trace);
        trace.printStackTrace(System.out);
        return null;
    }

    public static void stop() throws DbException {
        try {
            TestFishEyeInstances.stopRepositories();
            if (AppConfig.getsConfig().getCrossRepLuceneIndex() != null) {
                AppConfig.getsConfig().getCrossRepLuceneIndex().close();
            }
            if (SpringContext.isSetup() && SpringContext.isBeanPresent((String)"reviewItemIndexer")) {
                DefaultReviewItemIndexer.doStop();
            }
            try {
                int sessionCount = HibernateUtil.getSessionCount();
                if (sessionCount != 0) {
                    HibernateUtil.reportOpenSessions();
                    String message = "Not all hibernate sessions were closed - " + sessionCount + " remain open";
                    throw new IllegalStateException(message);
                }
                TestCase.assertEquals((String)"Your test is broken if this assert fails.", (int)0, (int)AppConfig.getsConfig().getRepositoryManager().getNumberNotStopped());
            }
            finally {
                AppConfig.getsConfig().fullShutdown();
                if (dbControlFactory != null) {
                    DBControl control = dbControlFactory.getCurrentControl();
                    control.stop();
                    if (control.getInfo().state().equals((Object)DBInfo.DBState.STOPPED)) {
                        control.dropTables();
                    }
                    dbControlFactory.setCurrentControl(null);
                    dbControlFactory = null;
                }
                if (ws != null) {
                    ws.stop();
                    AppConfig.setWebServer(null);
                    ws = null;
                    SpringContext.setApplicationContext(null);
                    sanity1loaded = false;
                    sanity1Loader = null;
                    sanity1LaterLoaders.clear();
                }
                MetricsManager.INSTANCE.clearCache();
                TestFishEyeInstances.checkProxyCache();
            }
        }
        catch (CruDBException e) {
            throw new DbException("Error stopping test instances", (Throwable)e);
        }
    }

    private static void checkProxyCache() {
        try {
            Class<?> sourceKlass = Class.forName("org.springframework.cglib.core.AbstractClassGenerator$Source");
            Field sourceField = ReflectionUtils.findField(Enhancer.class, (String)"SOURCE");
            sourceField.setAccessible(true);
            Object sourceInstance = sourceField.get(null);
            Field cacheField = ReflectionUtils.findField(sourceKlass, (String)"cache");
            cacheField.setAccessible(true);
            Map cache = (Map)cacheField.get(sourceInstance);
            Assert.assertThat((String)("Enhancer cache seems leaky: " + cache), (Object)cache.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void stopRepositories() {
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        for (String rep : rm.getHandleMap().keySet()) {
            RepositoryHandle rh = rm.getRepository(rep);
            if (!rh.isRunning() || rh.tryStop(10000L)) continue;
            throw new RuntimeException("could not stop repository " + rep);
        }
    }

    private static void restartRepositories() throws Exception {
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        for (String rep : rm.getHandleMap().keySet()) {
            System.out.println("RESTARTING " + rep);
            RepositoryHandle rh = rm.getRepository(rep);
            if (rh.isRunning()) continue;
            rm.runRepository(rep);
            System.out.println("wasn't running, restarting " + rep);
            TestFishEyeInstances.fullslurp(rh);
        }
    }

    public static ConfigDocument loadConfigDocumentFromStream(InputStream in) throws IOException, XmlException {
        int c;
        StringBuilder buf = new StringBuilder();
        while (-1 != (c = in.read())) {
            buf.append((char)c);
        }
        String cfgStr = buf.toString();
        cfgStr = cfgStr.replaceAll("@WORKSPACE_DIR@", "/Users/kcichy/src/fecru_d");
        cfgStr = cfgStr.replaceAll("@LISTENPORT@", Integer.toString(6060));
        cfgStr = cfgStr.replaceAll("@SMTPPORT@", Integer.toString(6025));
        cfgStr = cfgStr.replaceAll("@CONTROLPORT@", Integer.toString(6061));
        XmlOptions opts = new XmlOptions();
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        return ConfigDocument.Factory.parse((String)cfgStr, (XmlOptions)opts);
    }

    private static void fullslurp(RepositoryHandle rep) throws Exception {
        RepositoryEngine engine = rep.acquireEngine();
        engine.requestFullscan();
        long ts1 = System.currentTimeMillis();
        rep.oneOffScan(true);
        if (rep.isPipelined()) {
            boolean done;
            ConcurrentMap stateCounts = rep.getStatus().getIndexingStateCounts();
            int count = 0;
            do {
                done = true;
                for (ChangeSetIndexingState state : ChangeSetIndexingState.values()) {
                    if (state != ChangeSetIndexingState.COMPLETE) {
                        if (((AtomicInteger)stateCounts.get(state)).intValue() <= 0) continue;
                        done = false;
                        break;
                    }
                    if (((AtomicInteger)stateCounts.get(state)).intValue() != 0) continue;
                    done = false;
                    break;
                }
                if (done) continue;
                Thread.sleep(1000L);
                rep.oneOffScan(true);
            } while (!done && count++ < 30);
            if (!done) {
                throw new Exception("Full slurp of " + rep.getName() + " did not finish in time. Waited " + (System.currentTimeMillis() - ts1) + "ms");
            }
        }
    }

    public static File getSanity1Dir() {
        return new File(FisheyeTestUtil.getTmpDir(), "sanity1");
    }

    public static void deleteData0() throws Exception {
        if (sanity1loaded) {
            TestFishEyeInstances.stop();
        }
        File cachedir = new File(TestFishEyeInstances.getSanity1Dir(), "var/data/data0.bin");
        cachedir.delete();
    }

    private static void assertSanity1Closed() {
        if (sanity1loaded) {
            System.err.println("FIRST LOADED BY");
            sanity1Loader.printStackTrace();
            for (Throwable t : sanity1LaterLoaders) {
                System.err.println("later requested by:");
                t.printStackTrace();
            }
            throw new IllegalStateException("you need to stop() first", sanity1Loader);
        }
    }

    public static void deleteCruDB() throws Exception {
        if (sanity1loaded) {
            TestFishEyeInstances.stop();
        }
        if (AppConfig.getsConfig().getConfigDocument() != null) {
            TestFishEyeInstances.getDBControlFactory().getCurrentControl().stop();
        }
        File dir = new File(TestFishEyeInstances.getSanity1Dir(), "var/data/crudb");
        IOHelper.recursiveDelete((File)dir, (int)5, (boolean)true);
    }

    static {
        Run.setLibraryProperties();
        HibernateUtil.turnSessionTrackingOn();
        LegacyRepositoryManagerRootConfig.resetConfig();
    }
}

