/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.PassivateManager;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryHandleTest {
    @Mock
    private RepositoryConfig config;
    @Mock
    private UpgradeManager upgradeManager;
    @Mock
    private IndexingContext indexingContext;
    @Mock
    private PassivateManager passivateManager;
    @Mock
    private ApplicationContext applicationContext;
    @Mock
    private EventPublisher eventPublisher;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RepositoryEngine repositoryEngine;
    private RepositoryHandle repositoryHandle;

    @Before
    public void setUp() throws Exception {
        SpringContext.setApplicationContext((ApplicationContext)this.applicationContext);
        Mockito.when((Object)this.indexingContext.getEventPublisher()).thenReturn((Object)this.eventPublisher);
        Mockito.when((Object)this.config.getStatus()).thenReturn((Object)new RepositoryStatus("status"));
        Mockito.when((Object)this.config.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.config.createRepositoryEngine((UpgradeManager)Mockito.any(UpgradeManager.class), (IndexingContext)Mockito.any(IndexingContext.class))).thenReturn((Object)this.repositoryEngine);
        this.repositoryHandle = new RepositoryHandle("repoHandle", this.config, this.indexingContext, this.passivateManager);
    }

    @Test
    public void testRunThrowsEx_EngineIsClosedAndRepoNotRunning() throws Exception {
        NoSuchElementException toBeThrown = new NoSuchElementException("some ex");
        ((RepositoryEngine)Mockito.doThrow((Throwable)toBeThrown).when((Object)this.repositoryEngine)).setDesiredInfDbCacheSize(Mockito.anyLong());
        boolean result = false;
        try {
            result = this.repositoryHandle.run(this.config);
        }
        catch (NoSuchElementException e) {
            Assert.assertSame((Object)toBeThrown, (Object)e);
        }
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)this.repositoryHandle.isRunning());
        ((RepositoryEngine)Mockito.verify((Object)this.repositoryEngine, (VerificationMode)Mockito.times((int)1))).forceClose();
    }

    @Test
    public void testRunCreateEngineThrowsEx_EngineIsClosedAndRepoNotRunning() throws Exception {
        NoSuchElementException toBeThrown = new NoSuchElementException("some ex");
        Mockito.when((Object)this.config.createRepositoryEngine((UpgradeManager)Mockito.any(UpgradeManager.class), (IndexingContext)Mockito.any(IndexingContext.class))).thenThrow(new Throwable[]{toBeThrown});
        boolean result = false;
        try {
            result = this.repositoryHandle.run(this.config);
        }
        catch (NoSuchElementException e) {
            Assert.assertSame((Object)toBeThrown, (Object)e);
        }
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)this.repositoryHandle.isRunning());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.repositoryEngine});
    }
}

