/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.Position;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class PositionTest {
    @Test
    public void testCreateInitial() {
        Position position = Position.initial();
        Assert.assertNotNull((Object)position);
        Assert.assertTrue((boolean)position.equals((Object)position));
        Assert.assertEquals((long)0L, (long)position.compareTo(position));
    }

    @Test
    public void testCreateLotsOfBefores() {
        LinkedList<Position> list = new LinkedList<Position>();
        Position earliest = Position.initial();
        for (int i = 0; i < 10000; ++i) {
            Position earlier = Position.createBefore((Position)earliest);
            Assert.assertEquals((long)-1L, (long)earlier.compareTo(earliest));
            list.addFirst(earlier);
            earliest = earlier;
        }
    }

    @Test
    public void testCreateLotsOfAfters() {
        LinkedList<Position> list = new LinkedList<Position>();
        Position latest = Position.initial();
        for (int i = 0; i < 10000; ++i) {
            Position later = Position.createAfter((Position)latest);
            Assert.assertEquals((long)1L, (long)later.compareTo(latest));
            list.addFirst(later);
            latest = later;
        }
    }

    @Test
    public void testCreateBetweenConsequetive() {
        Position first = new Position(new long[]{99L, 128L});
        Position second = new Position(new long[]{99L, 129L});
        Position between = Position.createBetween((Position)first, (Position)second, (double)0.5);
        Assert.assertEquals((long)1L, (long)between.compareTo(first));
        Assert.assertEquals((long)-1L, (long)between.compareTo(second));
        Assert.assertEquals((Object)new Position(new long[]{99L, 128L, 0x3FFFFFFFFFFFFFFFL}), (Object)between);
    }

    @Test
    public void testCreateBetweenShorterFirst() {
        Position first = new Position(new long[]{99L});
        Position second = new Position(new long[]{99L, 129L});
        Position between = Position.createBetween((Position)first, (Position)second, (double)0.5);
        Assert.assertEquals((long)1L, (long)between.compareTo(first));
        Assert.assertEquals((long)-1L, (long)between.compareTo(second));
        Assert.assertEquals((Object)new Position(new long[]{99L, 64L}), (Object)between);
    }

    @Test
    public void testCreateBetweenShorterLast() {
        Position first = new Position(new long[]{99L, 129L});
        Position second = new Position(new long[]{100L});
        Position between = Position.createBetween((Position)first, (Position)second, (double)0.5);
        Assert.assertEquals((long)1L, (long)between.compareTo(first));
        Assert.assertEquals((long)-1L, (long)between.compareTo(second));
        Assert.assertEquals((Object)new Position(new long[]{99L, 10000000129L}), (Object)between);
    }

    @Test
    public void testCreateBetweenWithLargeGap() {
        Position first = new Position(new long[]{99L, 0L});
        Position second = new Position(new long[]{Long.MAX_VALUE, 100L});
        Position between = Position.createBetween((Position)first, (Position)second, (double)0.5);
        Assert.assertEquals((long)1L, (long)between.compareTo(first));
        Assert.assertEquals((long)-1L, (long)between.compareTo(second));
        Assert.assertEquals((Object)new Position(new long[]{99L + Math.round(4.611686018427388E18)}), (Object)between);
    }

    @Test
    public void testWorstCaseInsertBetweens() {
        Position lowerLimit = Position.initial();
        Position upperLimit = Position.createAfter((Position)lowerLimit);
        Position between = null;
        int count = 0;
        do {
            between = Position.createBetween((Position)lowerLimit, (Position)upperLimit, (double)0.5);
            Assert.assertEquals((long)1L, (long)between.compareTo(lowerLimit));
            Assert.assertEquals((long)-1L, (long)between.compareTo(upperLimit));
            upperLimit = between;
            ++count;
        } while (upperLimit.getValue().length == 1);
        int maxBetweenInserts = (int)Math.ceil(Math.log10(1.0E10) / Math.log10(2.0));
        Assert.assertEquals((long)maxBetweenInserts, (long)count);
        count = 0;
        do {
            between = Position.createBetween((Position)lowerLimit, (Position)upperLimit, (double)0.5);
            Assert.assertEquals((long)1L, (long)between.compareTo(lowerLimit));
            Assert.assertEquals((long)-1L, (long)between.compareTo(upperLimit));
        } while ((upperLimit = between).getValue().length == 2 && ++count < 1000000);
        Assert.assertEquals((long)1000000L, (long)count);
    }

    private long date(int year, int month, int day) {
        return new GregorianCalendar(year, month, day).getTimeInMillis();
    }

    @Test
    public void testInsertBetweenFraction() {
        ArrayList<Long> dates = new ArrayList<Long>();
        for (int i = 2; i < 1000; ++i) {
            dates.add(this.date(2010, 6, i));
        }
        Position position = Position.initial();
        Position maxPosition = Position.createAfter((Position)position);
        long prevDate = this.date(2010, 6, 1);
        long maxDate = this.date(2013, 6, 1);
        int count = 0;
        for (Long date : dates) {
            double fraction = (1.0 * (double)date.longValue() - (double)prevDate) / (double)(maxDate - prevDate);
            Position between = Position.createBetween((Position)position, (Position)maxPosition, (double)fraction);
            Assert.assertEquals((long)1L, (long)between.compareTo(position));
            Assert.assertEquals((long)-1L, (long)between.compareTo(maxPosition));
            Assert.assertEquals((String)("after " + ++count + " positions, multiple longs were required"), (long)1L, (long)between.getValue().length);
            position = between;
            prevDate = date;
        }
    }

    @Test
    public void testCreateBetweenWithFractionCloseToZero() {
        Position position = Position.initial();
        Position maxPosition = Position.createAfter((Position)position);
        for (int i = 0; i < 1000; ++i) {
            Position between = Position.createBetween((Position)position, (Position)maxPosition, (double)1.0E-5);
            Assert.assertEquals((long)1L, (long)between.compareTo(position));
            Assert.assertEquals((long)-1L, (long)between.compareTo(maxPosition));
            maxPosition = between;
        }
    }

    protected double getDateDistanceFraction(long before, long between, long after) {
        if (after != before) {
            return (double)(between - before) / (double)(after - before);
        }
        return 0.0;
    }

    @Test
    public void testCreateBetweenRoundingUpToLast() {
        long date3390 = new GregorianCalendar(2005, 7, 8, 11, 48, 48).getTimeInMillis();
        long date3388 = new GregorianCalendar(2005, 7, 9, 9, 8, 12).getTimeInMillis();
        long date3389 = new GregorianCalendar(2005, 7, 9, 11, 46, 54).getTimeInMillis();
        long date3386 = new GregorianCalendar(2005, 7, 8, 8, 35, 29).getTimeInMillis();
        long dateOther = new GregorianCalendar(2010, 7, 8, 8, 35, 29).getTimeInMillis();
        Position pos3388 = new Position(new long[]{4611686028427387902L});
        Position pos3389 = new Position(new long[]{4611686028427387902L, 0x3FFFFFFFFFFFFFFFL});
        Position pos3386 = new Position(new long[]{4611686028427387901L});
        Position posOther = new Position(new long[]{4611686028427387903L});
        Position pos3390_1 = Position.createBetween((Position)pos3388, (Position)pos3389, (double)this.getDateDistanceFraction(date3388, date3390, date3389));
        Position pos3390_2 = Position.createBetween((Position)pos3386, (Position)pos3388, (double)this.getDateDistanceFraction(date3386, date3390, date3388));
        Position pos3390_3 = Position.createBetween((Position)pos3389, (Position)posOther, (double)this.getDateDistanceFraction(date3389, date3390, dateOther));
        System.out.println("\n" + pos3388);
        System.out.println(pos3390_1);
        System.out.println(pos3389);
        Assert.assertEquals((long)1L, (long)pos3390_1.compareTo(pos3388));
        Assert.assertEquals((long)-1L, (long)pos3390_1.compareTo(pos3389));
        System.out.println("\n" + pos3386);
        System.out.println(pos3390_2);
        System.out.println(pos3388);
        Assert.assertEquals((long)1L, (long)pos3390_2.compareTo(pos3386));
        Assert.assertEquals((long)-1L, (long)pos3390_2.compareTo(pos3388));
        System.out.println("\n" + pos3389);
        System.out.println(pos3390_3);
        System.out.println(posOther);
        Assert.assertEquals((long)1L, (long)pos3390_3.compareTo(pos3389));
        Assert.assertEquals((long)-1L, (long)pos3390_3.compareTo(posOther));
    }
}

