/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.CommitNotification;
import com.cenqua.fisheye.rep.HibernateCommitNotificationDAO;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class HibernateCommitNotificationDAOTest {
    @Autowired
    private HibernateCommitNotificationDAO commitNotificationDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private final Random rnd = new Random();

    @Test
    public void testApplicationContextSetUp() throws Exception {
        MatcherAssert.assertThat((Object)this.commitNotificationDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.sessionFactory, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testSaveCommitNotification() throws Exception {
        CommitNotification commitNotification = this.generateCommitNotification(this.generateRepName());
        MatcherAssert.assertThat((Object)commitNotification.getId(), (Matcher)Matchers.nullValue());
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification);
        MatcherAssert.assertThat((Object)commitNotification.getId(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testSaveCommitAndValidate() throws Exception {
        String rep = this.generateRepName();
        CommitNotification commitNotification = this.generateCommitNotification(rep);
        MatcherAssert.assertThat((Object)commitNotification.getId(), (Matcher)Matchers.nullValue());
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        CommitNotification commitNotificationReRead = this.commitNotificationDAO.getCommitNotification(rep);
        MatcherAssert.assertThat((Object)(commitNotificationReRead == commitNotification ? 1 : 0), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)commitNotificationReRead, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)commitNotification)));
        MatcherAssert.assertThat((Object)commitNotificationReRead.getCacheSerialOfLastRevision(), (Matcher)Matchers.equalTo((Object)commitNotification.getCacheSerialOfLastRevision()));
        MatcherAssert.assertThat((Object)commitNotificationReRead.getChangesetIndexSerial(), (Matcher)Matchers.equalTo((Object)commitNotification.getChangesetIndexSerial()));
        MatcherAssert.assertThat((Object)commitNotificationReRead.getLastChecked(), (Matcher)Matchers.equalTo((Object)commitNotification.getLastChecked()));
        MatcherAssert.assertThat((Object)commitNotificationReRead.getRep(), (Matcher)Matchers.equalTo((Object)commitNotification.getRep()));
        MatcherAssert.assertThat((Object)commitNotificationReRead.getId(), (Matcher)Matchers.equalTo((Object)commitNotification.getId()));
    }

    @Test(expected=Exception.class)
    public void testUniquenessCommitNotification() throws Exception {
        String rep = this.generateRepName();
        CommitNotification commitNotification1 = this.generateCommitNotification(rep);
        CommitNotification commitNotification2 = this.generateCommitNotification(rep);
        MatcherAssert.assertThat((Object)this.commitNotificationDAO.listCommitNotifications(), (Matcher)Matchers.hasSize((int)0));
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification1);
        MatcherAssert.assertThat((Object)this.commitNotificationDAO.listCommitNotifications(), (Matcher)Matchers.hasSize((int)1));
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification2);
        this.sessionFactory.getCurrentSession().flush();
        Assert.fail((String)"repository names in commit notifications not unique");
    }

    @Test
    public void testListCommitNotifications() throws Exception {
        int i;
        MatcherAssert.assertThat((Object)this.commitNotificationDAO.listCommitNotifications(), (Matcher)Matchers.hasSize((int)0));
        for (i = 0; i < 100; ++i) {
            this.commitNotificationDAO.saveOrUpdateCommitNotification(this.generateCommitNotification(this.generateRepName()));
        }
        MatcherAssert.assertThat((Object)this.commitNotificationDAO.listCommitNotifications(), (Matcher)Matchers.hasSize((int)100));
        for (i = 0; i < 100; ++i) {
            this.commitNotificationDAO.saveOrUpdateCommitNotification(this.generateCommitNotification(this.generateRepName()));
        }
        MatcherAssert.assertThat((Object)this.commitNotificationDAO.listCommitNotifications(), (Matcher)Matchers.hasSize((int)200));
    }

    @Test
    public void testGetCommitNotification() throws Exception {
        String rep = this.generateRepName();
        CommitNotification commitNotification = this.generateCommitNotification(rep);
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        CommitNotification commitNotificationReRead = this.commitNotificationDAO.getCommitNotification(rep);
        MatcherAssert.assertThat((Object)commitNotification, (Matcher)Matchers.equalTo((Object)commitNotificationReRead));
    }

    @Test
    public void testGetCommitNotificationNotFound() throws Exception {
        String rep = this.generateRepName();
        String otherRep = this.generateRepName();
        CommitNotification commitNotification1 = this.generateCommitNotification(rep);
        this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification1);
        CommitNotification commitNotification2 = this.commitNotificationDAO.getCommitNotification(otherRep);
        MatcherAssert.assertThat((Object)commitNotification2, (Matcher)Matchers.nullValue());
    }

    private CommitNotification generateCommitNotification(String rep) {
        CommitNotification commitNotification = new CommitNotification(rep);
        commitNotification.setCacheSerialOfLastRevision(this.rnd.nextLong());
        commitNotification.setChangesetIndexSerial(this.rnd.nextLong());
        commitNotification.setLastChecked(this.rnd.nextLong());
        return commitNotification;
    }

    private String generateRepName() {
        return "test_watch_rep_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }
}

