/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.DefaultCrossRepositorySearcher;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultCrossRepositorySearcherTest {
    public static final String REPOSITORY = "rep";
    @Mock
    private CrossRepLuceneIndex crossRepLuceneIndex;
    private TestDocInfoManager docInfoManager;
    private DefaultCrossRepositorySearcher searcher;

    @Before
    public void setUp() throws Exception {
        RAMDirectory indexDirectory = new RAMDirectory();
        this.docInfoManager = LuceneTestUtil.newRAMDocInfoManager((Directory)indexDirectory);
        LuceneConnection luceneConnection = LuceneTestUtil.mockLuceneConnection((Directory)indexDirectory);
        Mockito.when((Object)this.crossRepLuceneIndex.getConnection()).thenReturn((Object)luceneConnection);
        this.searcher = new DefaultCrossRepositorySearcher(null, null, null, this.crossRepLuceneIndex, null);
    }

    @Test
    public void testFindRecentlyModifiedBranches_exactMatchFirst() throws Exception {
        this.indexBranches(this.branch("branch-c", 4000L), this.branch("branch-b", 3000L), this.branch("branch-a", 2000L), this.branch("branch", 1000L));
        Pair result = this.searcher.findRecentlyModifiedBranches(REPOSITORY, "branch", 3);
        Assert.assertThat((String)"total hits", (Object)result.getFirst(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((String)"branches", (Object)result.getSecond(), (Matcher)Matchers.contains((Object[])new String[]{"branch", "branch-c", "branch-b"}));
    }

    @Test
    public void testFindRecentlyModifiedBranches_withoutExactMatch() throws Exception {
        this.indexBranches(this.branch("branch-c", 4000L), this.branch("branch-b", 3000L), this.branch("branch-a", 2000L), this.branch("branch", 1000L));
        Pair result = this.searcher.findRecentlyModifiedBranches(REPOSITORY, "branch-", 3);
        Assert.assertThat((String)"total hits", (Object)result.getFirst(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"branches", (Object)result.getSecond(), (Matcher)Matchers.contains((Object[])new String[]{"branch-c", "branch-b", "branch-a"}));
    }

    @Test
    public void testFindRecentlyModifiedBranches_withEmptyPrefix() throws Exception {
        this.indexBranches(this.branch("branch-c", 4000L), this.branch("branch-b", 3000L), this.branch("branch-a", 2000L), this.branch("branch", 1000L));
        Pair result = this.searcher.findRecentlyModifiedBranches(REPOSITORY, "", 3);
        Assert.assertThat((String)"total hits", (Object)result.getFirst(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((String)"branches", (Object)result.getSecond(), (Matcher)Matchers.contains((Object[])new String[]{"branch-c", "branch-b", "branch-a"}));
    }

    private BranchDoc branch(String name, long date) {
        return new BranchDoc(REPOSITORY, null, date, name, BranchState.ACTIVE, date, date);
    }

    private void indexBranches(BranchDoc ... branchDocs) throws IOException {
        LuceneTestUtil.indexDocs(this.docInfoManager, Iterables.transform(Arrays.asList(branchDocs), BranchDocInfo::fromBranchDoc));
    }
}

