/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fecru.test.FecruJUnit4ClassRunner;
import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.atlassian.fisheye.event.CommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.BranchChange;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommitEventGenerator;
import com.cenqua.fisheye.rep.CommitNotification;
import com.cenqua.fisheye.rep.DummyCommitNotificationDAO;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=FecruJUnit4ClassRunner.class)
public class CommitEventGeneratorTest
implements Answer<RepositoryScanProcessedEvent> {
    private static final String REP_NAME = "TEST";
    private List<Pair<String, Long>> testCsids = Lists.newArrayList();
    private List<Pair<BranchChange, Long>> testBranches = Lists.newArrayList();
    private long beforeInitialSlurp;
    private long initialSlurp;
    private long incrSlurp1;
    private long incrSlurp2;
    private long reindexSlurp;
    @Mock
    private RepositoryHandle repositoryHandle;
    @Mock
    private RevisionCache<? extends ChangeSet> revisionCache;
    private CrossRepLuceneIndex crossRepLuceneIndex;
    private CommitEventGenerator commitEventGenerator;
    private TxTemplate txTemplateMock;

    private long uniqueTimestamp() throws InterruptedException {
        long ts = System.currentTimeMillis();
        Thread.sleep(1L);
        return ts;
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.repositoryHandle.getName()).thenReturn((Object)REP_NAME);
        this.crossRepLuceneIndex = (CrossRepLuceneIndex)Mockito.mock(CrossRepLuceneIndex.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.txTemplateMock = (TxTemplate)Mockito.mock(TxTemplate.class);
        this.commitEventGenerator = (CommitEventGenerator)Mockito.spy((Object)new CommitEventGenerator(this.txTemplateMock, null, this.crossRepLuceneIndex, null, null));
        ((CommitEventGenerator)Mockito.doAnswer((Answer)this).when((Object)this.commitEventGenerator)).findChanges(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
        this.beforeInitialSlurp = this.uniqueTimestamp();
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"1", (Object)this.uniqueTimestamp()));
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"2", (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch1", BranchChange.ChangeType.ADDED), (Object)this.uniqueTimestamp()));
        this.initialSlurp = this.uniqueTimestamp();
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"3", (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch1", BranchChange.ChangeType.MODIFIED), (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch2", BranchChange.ChangeType.ADDED), (Object)this.uniqueTimestamp()));
        this.incrSlurp1 = this.uniqueTimestamp();
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"4", (Object)this.uniqueTimestamp()));
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"5", (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch1", BranchChange.ChangeType.REMOVED), (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch2", BranchChange.ChangeType.MODIFIED), (Object)this.uniqueTimestamp()));
        this.incrSlurp2 = this.uniqueTimestamp();
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"6", (Object)this.uniqueTimestamp()));
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"7", (Object)this.uniqueTimestamp()));
        this.testCsids.add((Pair<String, Long>)Pair.newInstance((Object)"8", (Object)this.uniqueTimestamp()));
        this.testBranches.add((Pair<BranchChange, Long>)Pair.newInstance((Object)this.createBranch("branch3", BranchChange.ChangeType.REMOVED), (Object)this.uniqueTimestamp()));
        this.reindexSlurp = this.uniqueTimestamp();
    }

    private BranchChange createBranch(String name, BranchChange.ChangeType type) {
        return new BranchChange(name, type);
    }

    @Test
    public void testGetChangeSets() throws Exception {
        CommitNotification notificationRecord = new CommitNotification(this.repositoryHandle.getName());
        long csn = 1337L;
        Mockito.when((Object)this.revisionCache.getCacheSerialNumber()).thenReturn((Object)csn);
        Mockito.when((Object)this.revisionCache.getLastModifiedDate()).thenReturn((Object)this.initialSlurp);
        RepositoryScanProcessedEvent initialSlurp = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        Assert.assertThat((Object)initialSlurp.getChangesetIds(), (Matcher)org.hamcrest.Matchers.empty());
        Assert.assertThat((Object)initialSlurp.getBranchChanges(), (Matcher)org.hamcrest.Matchers.empty());
        Mockito.reset((Object[])new RevisionCache[]{this.revisionCache});
        Mockito.when((Object)this.revisionCache.getCacheSerialNumber()).thenReturn((Object)csn);
        Mockito.when((Object)this.revisionCache.getLastModifiedDate()).thenReturn((Object)this.incrSlurp1);
        RepositoryScanProcessedEvent afterIncremental1 = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        Assert.assertArrayEquals((Object[])new Object[]{"3"}, (Object[])afterIncremental1.getChangesetIds().toArray());
        this.assertBranchChanges(afterIncremental1, (BranchChange)this.testBranches.get(1).getFirst(), (BranchChange)this.testBranches.get(2).getFirst());
        Mockito.reset((Object[])new RevisionCache[]{this.revisionCache});
        Mockito.when((Object)this.revisionCache.getCacheSerialNumber()).thenReturn((Object)csn);
        Mockito.when((Object)this.revisionCache.getLastModifiedDate()).thenReturn((Object)this.incrSlurp2);
        RepositoryScanProcessedEvent afterIncremental2 = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        Assert.assertArrayEquals((Object[])new Object[]{"4", "5"}, (Object[])afterIncremental2.getChangesetIds().toArray());
        this.assertBranchChanges(afterIncremental2, (BranchChange)this.testBranches.get(3).getFirst(), (BranchChange)this.testBranches.get(4).getFirst());
        Mockito.reset((Object[])new RevisionCache[]{this.revisionCache});
        csn = 1338L;
        Mockito.when((Object)this.revisionCache.getCacheSerialNumber()).thenReturn((Object)csn);
        Mockito.when((Object)this.revisionCache.getLastModifiedDate()).thenReturn((Object)this.reindexSlurp);
        RepositoryScanProcessedEvent afterReindex = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        Assert.assertThat((Object)afterReindex.getChangesetIds(), (Matcher)org.hamcrest.Matchers.empty());
        Assert.assertThat((Object)afterReindex.getBranchChanges(), (Matcher)org.hamcrest.Matchers.empty());
    }

    @Test
    public void testGetRepositoryChanges_onIndexUpgrade() throws Exception {
        CommitNotification notificationRecord = new CommitNotification(this.repositoryHandle.getName());
        notificationRecord.setLastChecked(this.beforeInitialSlurp);
        long newTimestamp = 1370333256372L;
        Mockito.when((Object)this.crossRepLuceneIndex.getConnection().getIndexSerial((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA)).thenReturn((Object)1370333256372L);
        Mockito.when((Object)this.revisionCache.getCacheSerialNumber()).thenReturn((Object)notificationRecord.getCacheSerialOfLastRevision());
        Mockito.when((Object)this.revisionCache.getLastModifiedDate()).thenReturn((Object)this.initialSlurp, (Object[])new Long[]{this.incrSlurp1});
        RepositoryScanProcessedEvent afterReindex = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        RepositoryScanProcessedEvent afterSubsequentSlurp = this.commitEventGenerator.getRepositoryChanges(notificationRecord, this.repositoryHandle.getName(), this.revisionCache);
        Assert.assertEquals((long)0L, (long)afterReindex.getChangesetIds().size());
        Assert.assertEquals((long)0L, (long)afterReindex.getBranchChanges().size());
        Assert.assertEquals((long)1370333256372L, (long)notificationRecord.getChangesetIndexSerial());
        Assert.assertThat((Object)afterSubsequentSlurp.getChangesetIds(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{(String)this.testCsids.get(2).getFirst()}));
        this.assertBranchChanges(afterSubsequentSlurp, (BranchChange)this.testBranches.get(1).getFirst(), (BranchChange)this.testBranches.get(2).getFirst());
    }

    @Test
    public void testEmitsEventsInOrder() throws Exception {
        RepositoryHandle handle = FisheyeTestUtil.mockRepoHandle(REP_NAME);
        EventPublisher eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        RepositoryManager repoManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        final RepositoryScanProcessedEvent repChanges = new RepositoryScanProcessedEvent(REP_NAME, Collections.singleton("changeset"), Collections.singleton(new BranchChange("branch", BranchChange.ChangeType.MODIFIED)));
        Mockito.when((Object)repoManager.getRepository(REP_NAME)).thenReturn((Object)handle);
        this.commitEventGenerator = new CommitEventGenerator((TxTemplate)new DummyTxTemplate(), new DummyCommitNotificationDAO(), (CrossRepLuceneIndex)Mockito.mock(CrossRepLuceneIndex.class), repoManager, eventPublisher, (Executor)MoreExecutors.sameThreadExecutor()){

            protected RepositoryScanProcessedEvent getRepositoryChanges(CommitNotification commitNotification, String repoName, RevisionCache<? extends ChangeSet> revCache) {
                return repChanges;
            }
        };
        InOrder eventOrder = Mockito.inOrder((Object[])new Object[]{eventPublisher});
        this.commitEventGenerator.onChangesetsIndexed(new ChangesetsIndexedEvent(REP_NAME));
        ((EventPublisher)eventOrder.verify((Object)eventPublisher)).publish((Object)new CommitEventImpl(REP_NAME, (String)Iterables.getOnlyElement((Iterable)repChanges.getChangesetIds())));
        ((EventPublisher)eventOrder.verify((Object)eventPublisher)).publish((Object)repChanges);
    }

    @Test
    public void testFindChanges() throws Exception {
        RAMDirectory indexDirectory = new RAMDirectory();
        TestDocInfoManager docInfoManager = LuceneTestUtil.newRAMDocInfoManager((Directory)indexDirectory);
        LuceneConnection luceneConnection = LuceneTestUtil.mockLuceneConnection((Directory)indexDirectory);
        Mockito.when((Object)this.crossRepLuceneIndex.getConnection()).thenReturn((Object)luceneConnection);
        this.indexChangesets(docInfoManager, this.changeset("1", 1000L), this.changeset("2", 2000L), this.changeset("3", 3000L), this.changeset("4", 4000L), this.changeset("5", 5000L));
        this.indexBranches(docInfoManager, this.branch("branch-active-before", BranchState.ACTIVE, 1000L), this.branch("branch-active-1", BranchState.ACTIVE, 2000L, 0L), this.branch("branch-active-2", BranchState.ACTIVE, 2000L), this.branch("branch-closed", BranchState.CLOSED, 3000L), this.branch("branch-removed", BranchState.REMOVED, 4000L), this.branch("branch-active-after", BranchState.ACTIVE, 5000L));
        this.commitEventGenerator = new CommitEventGenerator(this.txTemplateMock, null, this.crossRepLuceneIndex, null, null);
        RepositoryScanProcessedEvent event = this.commitEventGenerator.findChanges(REP_NAME, 1500L, 4500L);
        Assert.assertThat((Object)event.getRepository(), (Matcher)org.hamcrest.Matchers.is((Object)REP_NAME));
        Assert.assertThat((Object)event.getChangesetIds(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"2", "3", "4"}));
        Assert.assertThat((Object)event.getBranchChanges(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new BranchChange[]{new BranchChange("branch-active-1", BranchChange.ChangeType.MODIFIED), new BranchChange("branch-active-2", BranchChange.ChangeType.ADDED), new BranchChange("branch-closed", BranchChange.ChangeType.REMOVED), new BranchChange("branch-removed", BranchChange.ChangeType.REMOVED)}));
    }

    private ChangesetDoc changeset(String csId, long date) {
        return ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet(REP_NAME, csId, "author", "msg", date, "master"));
    }

    private BranchDoc branch(String branchName, BranchState branchState, long lastIndexedTimeStamp) {
        return this.branch(branchName, branchState, lastIndexedTimeStamp, lastIndexedTimeStamp);
    }

    private BranchDoc branch(String branchName, BranchState branchState, long lastIndexedTimeStamp, long firstIndexedTimeStamp) {
        return new BranchDoc(REP_NAME, null, firstIndexedTimeStamp, branchName, branchState, lastIndexedTimeStamp, firstIndexedTimeStamp);
    }

    private void indexChangesets(TestDocInfoManager docInfoManager, ChangesetDoc ... changesetDocs) throws IOException {
        LuceneTestUtil.indexDocs(docInfoManager, Iterables.transform(Arrays.asList(changesetDocs), changesetDoc -> new ChangesetDocInfo(changesetDoc, changesetDoc.getDate())));
    }

    private void indexBranches(TestDocInfoManager docInfoManager, BranchDoc ... branchDocs) throws IOException {
        LuceneTestUtil.indexDocs(docInfoManager, Iterables.transform(Arrays.asList(branchDocs), branchDoc -> BranchDocInfo.fromBranchDoc((BranchDoc)branchDoc)));
    }

    private void assertBranchChanges(RepositoryScanProcessedEvent afterSubsequentSlurp, BranchChange ... branchChanges) {
        Assert.assertThat((Object)afterSubsequentSlurp.getBranchChanges(), (Matcher)org.hamcrest.Matchers.contains((Object[])branchChanges));
    }

    public RepositoryScanProcessedEvent answer(InvocationOnMock invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        long min = (Long)args[1];
        long max = (Long)args[2];
        ArrayList csids = Lists.newArrayList();
        for (Pair<String, Long> csid : this.testCsids) {
            if (min >= (Long)csid.getSecond() || (Long)csid.getSecond() > max) continue;
            csids.add(csid.getFirst());
        }
        ArrayList branches = Lists.newArrayList();
        for (Pair<BranchChange, Long> branch : this.testBranches) {
            if (min >= (Long)branch.getSecond() || (Long)branch.getSecond() > max) continue;
            branches.add(branch.getFirst());
        }
        return new RepositoryScanProcessedEvent(REP_NAME, (Iterable)csids, (Iterable)branches);
    }
}

