/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DefaultTxTemplate;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.rep.CommitEventGenerator;
import com.cenqua.fisheye.rep.CommitNotification;
import com.cenqua.fisheye.rep.CommitNotificationDAO;
import com.cenqua.fisheye.rep.HibernateCommitNotificationDAO;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.File;
import java.util.concurrent.Executor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class CommitEventGeneratorIntegrationDbTest {
    public TemporaryFolder temp = new TemporaryFolder();
    private CommitEventGenerator commitEventGenerator;
    private RepositoryHandle handle;
    private RevisionCache cache = (RevisionCache)Mockito.mock(RevisionCache.class);
    private Executor waitingExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            Thread thread = new Thread(command);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private DefaultDBControl control;

    @Before
    public void setUp() throws Exception {
        this.temp.create();
        DatabaseConfig config = new DatabaseConfig(DBType.HSQL, "jdbc:hsqldb:" + this.temp.newFolder("db"), "sa", "", DriverSource.BUNDLED, 5, 10);
        this.control = DefaultDBControl.newInstance((DatabaseConfig)config, (File)new File("etc/dist/sql"));
        this.control.start();
        this.handle = FisheyeTestUtil.mockRepoHandle("repo");
        RepositoryManager repositoryManager = FisheyeTestUtil.mockRepoManager(this.handle);
        RepositoryEngine engine = this.handle.acquireEngine();
        Mockito.when((Object)engine.getRevisionCache()).thenReturn((Object)this.cache);
        this.commitEventGenerator = new CommitEventGenerator((TxTemplate)new DefaultTxTemplate(null), (CommitNotificationDAO)new HibernateCommitNotificationDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), new CrossRepLuceneIndex(this.temp.newFolder("xrepoCache")), repositoryManager, null, this.waitingExecutor);
    }

    @After
    public void tearDown() throws Exception {
        this.control.stop();
        this.temp.delete();
    }

    @Test
    public void testCommitNotifications() throws Exception {
        ChangesetsIndexedEvent repoEvent = new ChangesetsIndexedEvent(this.handle.getName());
        Mockito.when((Object)this.cache.getLastModifiedDate()).thenReturn((Object)100L, (Object[])new Long[]{200L});
        this.commitEventGenerator.onChangesetsIndexed(repoEvent);
        long afterFirstCheck = this.getCommitNotification().getLastChecked();
        this.commitEventGenerator.onChangesetsIndexed(repoEvent);
        long afterSecondCheck = this.getCommitNotification().getLastChecked();
        Assert.assertThat((Object)afterFirstCheck, (Matcher)CoreMatchers.equalTo((Object)100L));
        Assert.assertThat((Object)afterSecondCheck, (Matcher)CoreMatchers.equalTo((Object)200L));
    }

    private CommitNotification getCommitNotification() {
        try {
            HibernateUtil.closeSession();
            CommitNotification commitNotification = (CommitNotification)HibernateUtil.currentSession().createCriteria(CommitNotification.class).uniqueResult();
            return commitNotification;
        }
        finally {
            HibernateUtil.closeSession();
        }
    }
}

