/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.AncestryTester;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;

public abstract class ChangesetAncestryTester {
    private final RevisionCache cache;

    public ChangesetAncestryTester(RevisionCache cache) {
        this.cache = cache;
    }

    public abstract String getChangeSetId(Action var1);

    protected ChangeSet getCs(Action action) throws DbException {
        return this.cache.getChangeSet(this.getChangeSetId(action));
    }

    public void verifyStraightCommitsOnMain() throws Exception {
        ChangeSet mainCreate = this.getCs(Action.MAIN_CREATE);
        ChangeSet mainAdd = this.getCs(Action.MAIN_ADD);
        ChangeSet mainEdit1 = this.getCs(Action.MAIN_EDIT_1);
        ChangeSet mainEdit2 = this.getCs(Action.MAIN_EDIT_2);
        AncestryTester.assertParents(this.cache, mainCreate, new String[0]);
        AncestryTester.assertParents(this.cache, mainAdd, mainCreate.getId());
        AncestryTester.assertParents(this.cache, mainEdit1, mainAdd.getId());
        AncestryTester.assertParents(this.cache, mainEdit2, mainEdit1.getId());
    }

    public void verifyBranchOfMain() throws Exception {
        ChangeSet mainEdit1 = this.getCs(Action.MAIN_EDIT_1);
        ChangeSet branchACreate = this.getCs(Action.BRANCH_A_CREATE);
        ChangeSet branchAEdit = this.getCs(Action.BRANCH_A_EDIT);
        AncestryTester.assertParents(this.cache, branchACreate, mainEdit1.getId());
        AncestryTester.assertParents(this.cache, branchAEdit, branchACreate.getId());
    }

    public void verifyBranchOfBranch() throws Exception {
        ChangeSet branchAEdit = this.getCs(Action.BRANCH_A_EDIT);
        ChangeSet branchAACreate = this.getCs(Action.BRANCH_A_A_CREATE);
        AncestryTester.assertParents(this.cache, branchAACreate, branchAEdit.getId());
    }

    public static enum Action {
        MAIN_CREATE,
        MAIN_ADD,
        MAIN_EDIT_1,
        BRANCH_A_CREATE,
        BRANCH_A_EDIT,
        BRANCH_B_CREATE,
        BRANCH_B_EDIT,
        BRANCH_A_A_CREATE,
        TAG_1_CREATE,
        TAG_2_CREATE,
        MAIN_EDIT_2;

    }
}

