/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionTest;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChangeSetImplTest {
    @Test
    public void testIsNotMetadataChangeIfNoChangesets() {
        TestChangeSetImpl cs = new TestChangeSetImpl(Collections.emptyList());
        Assert.assertFalse((boolean)cs.isMetadataOnlyChange());
    }

    @Test
    public void testIsNonTextualIfOnlyModifiedRevisionWithNoTextualChanges() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertTrue((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newModifiedRevision())).isMetadataOnlyChange());
    }

    @Test
    public void testIsNonMetadataChangeIfLinesChanged() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        CommonFileRevisionTest.TestFileRevision revision = CommonFileRevisionTest.newModifiedRevision();
        revision.setLinesAdded(1);
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(revision)).isMetadataOnlyChange());
    }

    @Test
    public void testIsNonMetadataChangeIfAddedRevision() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newAddedRevision())).isMetadataOnlyChange());
    }

    @Test
    public void testIsNonMetadataChangeIfDeletedRevision() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newDeletedRevision())).isMetadataOnlyChange());
    }

    @Test
    public void testIsNonMetadataChangeIfBinaryRevision() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newBinaryRevision())).isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfAtLeastOneNonMetadataRevision() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        CommonFileRevisionTest.TestFileRevision revision1 = CommonFileRevisionTest.newModifiedRevision();
        revision1.setLinesAdded(1);
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(revision1, CommonFileRevisionTest.newModifiedRevision())).isMetadataOnlyChange());
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newAddedRevision(), CommonFileRevisionTest.newModifiedRevision())).isMetadataOnlyChange());
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newDeletedRevision(), CommonFileRevisionTest.newModifiedRevision())).isMetadataOnlyChange());
        Assert.assertFalse((boolean)new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newBinaryRevision(), CommonFileRevisionTest.newModifiedRevision())).isMetadataOnlyChange());
    }

    @Test
    public void testIsMetadataChangeIfOneModificationWithoutLinesChanged() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        TestChangeSetImpl cs = new TestChangeSetImpl(Arrays.asList(CommonFileRevisionTest.newModifiedRevision()));
        Assert.assertTrue((boolean)cs.isMetadataOnlyChange());
    }

    @Test
    public void testDateCompareDifferentDates() {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
        TestChangeSetImpl cs1 = new TestChangeSetImpl("A", formatter.parseMillis("2011/01/20"), "TEST");
        TestChangeSetImpl cs2 = new TestChangeSetImpl("B", formatter.parseMillis("2011/01/19"), "TEST");
        Assert.assertEquals((String)"Primary ChangesetImpl sort should be based on date: cs1 should be after cs2", (long)1L, (long)cs1.dateCompare((ChangeSet)cs2));
        Assert.assertEquals((String)"Primary ChangesetImpl sort should be based on datecs1 should be before cs2", (long)-1L, (long)cs2.dateCompare((ChangeSet)cs1));
        cs1 = new TestChangeSetImpl("A", formatter.parseMillis("2011/01/20"), "TEST");
        cs2 = new TestChangeSetImpl("B", formatter.parseMillis("2011/01/20"), "TEST");
        Assert.assertEquals((String)"Secondary ChangesetImpl sort should be based on csid if same repo: cs1 should be before cs2", (long)-1L, (long)cs1.dateCompare((ChangeSet)cs2));
        Assert.assertEquals((String)"Secondary ChangesetImpl sort should be based on csid if same repo: cs1 should be after cs2", (long)1L, (long)cs2.dateCompare((ChangeSet)cs1));
        cs1 = new TestChangeSetImpl("A", formatter.parseMillis("2011/01/20"), "TEST_a");
        cs2 = new TestChangeSetImpl("A", formatter.parseMillis("2011/01/20"), "TEST_b");
        Assert.assertEquals((String)"Secondary ChangesetImpl sort should be based on RepName: cs1 should be before cs2", (long)-1L, (long)cs1.dateCompare((ChangeSet)cs2));
        Assert.assertEquals((String)"Secondary ChangesetImpl sort should be based on RepName: cs1 should be after cs2", (long)1L, (long)cs2.dateCompare((ChangeSet)cs1));
    }

    @Test
    public void testNaturalOrdering() throws Exception {
        Position initial = Position.initial();
        Position earlier = Position.createBefore((Position)initial);
        TestChangeSetImpl cs1 = new TestChangeSetImpl(earlier);
        TestChangeSetImpl cs2 = new TestChangeSetImpl(initial);
        Assert.assertEquals((String)"Same position is equal to itself", (long)0L, (long)cs1.compareTo((Object)cs1));
        Assert.assertEquals((String)"Earlier positioned changeset is before a later positioned changeset", (long)-1L, (long)cs1.compareTo((Object)cs2));
        Assert.assertEquals((String)"Later positioned changeset is after an earlier positioned changeset", (long)1L, (long)cs2.compareTo((Object)cs1));
    }

    public static class TestChangeSetImpl
    extends ChangeSetImpl<CommonFileRevisionTest.TestFileRevision> {
        private List<CommonFileRevisionTest.TestFileRevision> revisions;
        private String id;
        private long date;
        private String repName;
        private Position position;

        public TestChangeSetImpl(List<CommonFileRevisionTest.TestFileRevision> revisions) {
            this.revisions = revisions;
        }

        public TestChangeSetImpl(Position position) {
            this.position = position;
        }

        public TestChangeSetImpl(String id, long date, String repName) {
            this.id = id;
            this.date = date;
            this.repName = repName;
        }

        public String getId() {
            return this.id;
        }

        public long getDate() {
            return this.date;
        }

        public String getRepName() {
            return this.repName;
        }

        public Position getPosition() {
            return this.position;
        }

        public void visitRevisions(StoppableVisitor<FileRevision> visitor) throws DbException {
            for (CommonFileRevisionTest.TestFileRevision revision : this.revisions) {
                visitor.visit((Object)revision);
            }
        }

        public void visitRevisions(Visitor<FileRevision> visitor, Predicate<Integer> breakCondition) throws DbException {
            for (CommonFileRevisionTest.TestFileRevision revision : this.revisions) {
                visitor.visit((Object)revision);
                if (!breakCondition.apply((Object)revision.getRevID())) continue;
                break;
            }
        }
    }
}

