/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetDescriber;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.rep.DummyFileRevision;
import com.cenqua.fisheye.rep.FileRevision;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ChangeSetDescriberTest {
    @Test
    public void testDescribeNoFiles() throws Exception {
        TestChangeSet cs = new TestChangeSet(new ArrayList());
        Assert.assertEquals((String)"No files description is incorrect", (Object)"changed 0 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    @Test
    public void testDescribeAddedOneFile() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createAddFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"One file description is incorrect", (Object)"added 1 file", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createAddFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isAdded() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeAddedFiles() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createAddFileRevision(), this.createAddFileRevision(), this.createAddFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"added 3 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createDeleteFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isDead() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeDeletedFiles() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createDeleteFileRevision(), this.createDeleteFileRevision(), this.createDeleteFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"deleted 3 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createCopiedFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isCopy() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeCopiedFiles() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createCopiedFileRevision(), this.createCopiedFileRevision(), this.createCopiedFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"copied 3 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createMovedFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isMove() {
                return true;
            }
        };
    }

    private FileRevision createMetadataOnlyChangeFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isMetadataOnlyChange() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeMovedFiles() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createMovedFileRevision(), this.createMovedFileRevision(), this.createMovedFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"moved 3 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createUpdatedFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public boolean isModify() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeUpdatedFiles() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createUpdatedFileRevision(), this.createUpdatedFileRevision(), this.createUpdatedFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"updated 3 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private FileRevision createModifiedFileRevision() {
        return new DummyFileRevision(){

            @Override
            public boolean isModify() {
                return true;
            }
        };
    }

    @Test
    public void testDescribeMetadataOnlyChangeset() throws Exception {
        ArrayList revs = Lists.newArrayList((Object[])new FileRevision[]{this.createMetadataOnlyChangeFileRevision(), this.createMetadataOnlyChangeFileRevision()});
        TestChangeSet cs = new TestChangeSet(revs);
        Assert.assertEquals((String)"Added files description is incorrect", (Object)"updated metadata for 2 files", (Object)ChangeSetDescriber.describe((ChangeSet)cs));
    }

    private static class TestChangeSet
    extends DummyChangeSet<FileRevision> {
        private List<FileRevision> revisions;

        private TestChangeSet(List<FileRevision> revisions) {
            this.revisions = revisions;
        }

        public List<FileRevision> getFileRevisions() {
            return this.revisions;
        }

        public int compareSecondarySort(ChangeSet bound) {
            return 0;
        }

        @Override
        public Set<Integer> getReviewIds() throws DbException {
            return null;
        }

        public int getRevisionInfosCount() {
            return this.revisions.size();
        }

        public void visitRevisions(StoppableVisitor<FileRevision> visitor) throws DbException {
            for (FileRevision revision : this.revisions) {
                visitor.visit((Object)revision);
            }
        }
    }
}

