/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.Position;
import java.util.List;
import org.junit.Assert;

public class AncestryTester {
    public static void assertParents(RevisionCache cache, ChangeSet cs, String ... expectedParentIds) {
        Assert.assertNotNull((String)"Changeset was null", (Object)cs);
        List actualParentIds = cs.getParents();
        Assert.assertNotNull((Object)actualParentIds);
        Assert.assertEquals((long)expectedParentIds.length, (long)actualParentIds.size());
        for (String expectedId : expectedParentIds) {
            Assert.assertTrue((String)("Parents did not include " + expectedId), (boolean)actualParentIds.contains(expectedId));
        }
        Position csPosition = cs.getPosition();
        for (String parentId : actualParentIds) {
            ChangeSet parentCs = cache.getChangeSet(parentId);
            Position parentPosition = parentCs.getPosition();
            Assert.assertTrue((String)("Parent " + parentId + "@" + parentPosition + " is not positioned before child " + cs.getId() + "@" + csPosition), (parentPosition.compareTo(csPosition) < 0 ? 1 : 0) != 0);
        }
    }
}

