/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public class P4Server {
    static String p4dExecutable = "p4d";
    private File serverRoot;
    private long serverPort;
    private volatile Process serverProcess;
    private final StringBuffer serverOutput = new StringBuffer();
    private final StringBuffer serverError = new StringBuffer();

    public static void setP4dExecutable(String p4dExecutable) {
        P4Server.p4dExecutable = p4dExecutable;
    }

    public String loadCheckpoint(String checkPointName) throws P4ClientException {
        return this.executeCommand(p4dExecutable, "-r", this.serverRoot.getAbsolutePath(), "-p", Long.toString(this.serverPort), "-jr", checkPointName);
    }

    private String executeCommand(String ... command) throws P4ClientException {
        try {
            Logs.APP_LOG.info((Object)("Executing " + Arrays.asList(command)));
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            StringBuffer output = new StringBuffer();
            StringBuffer error = new StringBuffer();
            Thread outputThread = this.processOutput("P4Server Output", process.getInputStream(), output);
            Thread errorThread = this.processOutput("P4Server Error", process.getErrorStream(), error);
            int exitValue = process.waitFor();
            outputThread.join();
            errorThread.join();
            if (exitValue != 0) {
                throw new P4ClientException("Non zero exit value: " + exitValue + ", output = " + output + ", error = " + error);
            }
            outputThread.join();
            errorThread.join();
            return output.toString();
        }
        catch (IOException | InterruptedException e) {
            throw new P4ClientException((Throwable)e);
        }
    }

    private Thread processOutput(String name, InputStream ioStream, StringBuffer output) {
        Runnable outputReaderRunnable = () -> {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(ioStream));
                while ((line = reader.readLine()) != null) {
                    output.append(line).append('\n');
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        Thread outputThread = new Thread(outputReaderRunnable, name);
        outputThread.start();
        return outputThread;
    }

    public synchronized void start(boolean unicode) throws P4ClientException {
        if (this.serverProcess != null) {
            throw new P4ClientException("Server is already running");
        }
        this.stop(unicode);
        try {
            if (unicode) {
                this.executeCommand(p4dExecutable, "-r", this.serverRoot.getAbsolutePath(), "-xi");
            }
            String[] command = new String[]{p4dExecutable, "-r", this.serverRoot.getAbsolutePath(), "-p", Long.toString(this.serverPort)};
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.environment().put("P4JOURNAL", "off");
            this.serverProcess = builder.start();
            this.serverOutput.setLength(0);
            this.serverError.setLength(0);
            this.processOutput("P4Server Output", this.serverProcess.getInputStream(), this.serverOutput);
            this.processOutput("P4Server Error", this.serverProcess.getErrorStream(), this.serverError);
            try {
                int exitValue = this.serverProcess.exitValue();
                throw new P4ClientException("Server failed to start: " + this.serverError + " : " + exitValue);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        catch (IOException e) {
            throw new P4ClientException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean unicode) {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(Arrays.asList(P4Exec.getP4Executable(), "-p", "localhost:" + this.serverPort));
            if (unicode) {
                command.addAll(Arrays.asList("-C", "utf8"));
            }
            command.addAll(Arrays.asList("admin", "stop"));
            this.executeCommand(command.toArray(new String[0]));
            if (this.serverProcess != null) {
                Thread.sleep(1000L);
                int exitValue = this.serverProcess.waitFor();
                if (exitValue != 0) {
                    Logs.APP_LOG.error((Object)("Server failed: " + exitValue));
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.serverProcess != null) {
                this.serverProcess.destroy();
                this.serverProcess = null;
            }
        }
    }

    public void setServerRoot(File serverRoot) {
        this.serverRoot = serverRoot;
    }

    public void setServerPort(long serverPort) {
        this.serverPort = serverPort;
    }

    public String getOutput() {
        return this.serverOutput.toString();
    }

    public String getError() {
        return this.serverError.toString();
    }
}

