/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.DescribeProcessor;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DescribeProcessorTest {
    @Test
    public void testDescribeDeleteAndAdd() throws Exception {
        this.doTestDescribe("p4_describe_dn_2242.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)2242L, (Object)ImmutableMap.of((Object)"//guest/perforce_software/revml/TODO", (Object)ImmutableList.of((Object)new Hunk(3, 2, 4, 0), (Object)new Hunk(12, 9, 0, 7)))));
    }

    @Test
    public void testDescribeModifySingleLine() throws Exception {
        this.doTestDescribe("p4_describe_dn_3858.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)3858L, (Object)ImmutableMap.of((Object)"//guest/perforce_software/revml/Makefile.PL", (Object)ImmutableList.of((Object)new Hunk(9, 9, 1, 1)))));
    }

    @Test
    public void testDescribeModifyMultipleLines() throws Exception {
        this.doTestDescribe("p4_describe_dn_50.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)50L, (Object)ImmutableMap.of((Object)"//public/index.html", (Object)ImmutableList.of((Object)new Hunk(271, 271, 3, 5)))));
    }

    @Test
    public void testDescribeModifyMultipleLinesWithOffset() throws Exception {
        this.doTestDescribe("p4_describe_dn_52.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)52L, (Object)ImmutableMap.of((Object)"//guest/perforce_software/jam/index.html", (Object)ImmutableList.of((Object)new Hunk(15, 15, 4, 2), (Object)new Hunk(139, 137, 3, 3)))));
    }

    @Test
    public void testDescribeMultipleFiles() throws Exception {
        this.doTestDescribe("p4_describe_dn_4.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)4L, (Object)ImmutableMap.builder().put((Object)"//guest/perforce_software/jam/src/Jambase", (Object)ImmutableList.of((Object)new Hunk(215, 215, 1, 2), (Object)new Hunk(224, 226, 0, 7))).put((Object)"//guest/perforce_software/jam/src/RELNOTES", (Object)ImmutableList.of((Object)new Hunk(3, 4, 0, 4))).put((Object)"//guest/perforce_software/jam/src/execunix.c", (Object)ImmutableList.of((Object)new Hunk(12, 12, 1, 1), (Object)new Hunk(37, 37, 1, 1), (Object)new Hunk(42, 42, 1, 1), (Object)new Hunk(393, 393, 1, 1))).put((Object)"//guest/perforce_software/jam/src/fileunix.c", (Object)ImmutableList.of((Object)new Hunk(10, 10, 1, 1), (Object)new Hunk(52, 52, 1, 1), (Object)new Hunk(313, 313, 1, 1))).put((Object)"//guest/perforce_software/jam/src/jam.h", (Object)ImmutableList.of((Object)new Hunk(230, 231, 0, 3))).put((Object)"//guest/perforce_software/jam/src/jambase.c", (Object)ImmutableList.of((Object)new Hunk(52, 52, 1, 2), (Object)new Hunk(61, 63, 0, 7))).put((Object)"//guest/perforce_software/jam/src/patchlevel.h", (Object)ImmutableList.of((Object)new Hunk(6, 6, 1, 1))).put((Object)"//guest/perforce_software/jam/src/pathunix.c", (Object)ImmutableList.of((Object)new Hunk(10, 10, 1, 1), (Object)new Hunk(12, 12, 1, 1), (Object)new Hunk(19, 19, 1, 1), (Object)new Hunk(72, 73, 0, 1), (Object)new Hunk(78, 80, 0, 1), (Object)new Hunk(90, 93, 0, 1), (Object)new Hunk(95, 99, 0, 1), (Object)new Hunk(156, 160, 1, 1), (Object)new Hunk(192, 197, 0, 1), (Object)new Hunk(194, 200, 0, 1), (Object)new Hunk(240, 246, 1, 1))).build()));
    }

    @Test
    public void testDescribeSummaryTwoFiles() throws Exception {
        P4ChangeList p4ChangeList = this.getP4ChangeList("p4_describe_dn_16637.txt", (Set<Long>)ImmutableSet.of((Object)16637L), DescribeProcessor.DescribeType.SUMMARY).get(16637L);
        P4ChangePath changePath1 = p4ChangeList.getChangePath("//guest/perforce_software/sdp/main/Server/Unix/p4/common/bin/sdp_hosts.cfg");
        Assert.assertEquals((long)4L, (long)changePath1.getNumAdded());
        Assert.assertEquals((long)1L, (long)changePath1.getNumRemoved());
        P4ChangePath changePath2 = p4ChangeList.getChangePath("//guest/perforce_software/sdp/main/Server/Unix/p4/common/bin/sdp_sync.sh");
        Assert.assertEquals((long)140L, (long)changePath2.getNumAdded());
        Assert.assertEquals((long)29L, (long)changePath2.getNumRemoved());
    }

    @Test
    public void testDescribeDiffsThatContainDiffLikeText() throws Exception {
        this.doTestDescribe("p4_describe_dn_240.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)240L, (Object)ImmutableMap.of((Object)"//guest/richard_geiger/utils/cvs2p4/test/p4_describe.good", (Object)ImmutableList.of((Object)new Hunk(383, 384, 0, 14)))));
    }

    @Test
    public void testDescribeMultipleChangelistsWithNoTrailingEOF() throws Exception {
        this.doTestDescribe("p4_describe_dn_6_7.txt", (Map<Long, Map<String, List<Hunk>>>)ImmutableMap.of((Object)6L, (Object)ImmutableMap.of((Object)"//depot/test.txt", (Object)ImmutableList.of((Object)new Hunk(21, 21, 1, 1)), (Object)"//depot/test2.txt", (Object)ImmutableList.of((Object)new Hunk(34, 34, 1, 1))), (Object)7L, (Object)ImmutableMap.of((Object)"//depot/test.txt", (Object)ImmutableList.of((Object)new Hunk(20, 20, 2, 1)), (Object)"//depot/test2.txt", (Object)ImmutableList.of((Object)new Hunk(33, 33, 2, 1)))));
    }

    private void doTestDescribe(String fileName, Map<Long, Map<String, List<Hunk>>> expectedHunksForRevisions) throws Exception {
        Map<Long, P4ChangeList> changeLists = this.getP4ChangeList(fileName, expectedHunksForRevisions.keySet(), DescribeProcessor.DescribeType.RCS);
        for (Map.Entry<Long, Map<String, List<Hunk>>> expectedHunksForRevision : expectedHunksForRevisions.entrySet()) {
            P4ChangeList changeList = changeLists.get(expectedHunksForRevision.getKey());
            Map<String, List<Hunk>> expectedHunks = expectedHunksForRevision.getValue();
            for (Map.Entry<String, List<Hunk>> fileInChangelist : expectedHunks.entrySet()) {
                Assert.assertEquals((String)("Incorrect hunks for " + fileInChangelist.getKey()), fileInChangelist.getValue(), (Object)changeList.getChangePath(fileInChangelist.getKey()).getHunks());
            }
            Assert.assertEquals((long)expectedHunks.size(), (long)Iterators.size(changeList.getChangePaths().iterator()));
        }
    }

    private Map<Long, P4ChangeList> getP4ChangeList(String fileName, Set<Long> changelistIds, DescribeProcessor.DescribeType describeType) throws Exception {
        String input = DescribeProcessorTest.getResourceAsString(fileName);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input.getBytes(Charsets.UTF_8));
        P4RepositoryInfo repositoryInfo = (P4RepositoryInfo)Mockito.mock(P4RepositoryInfo.class);
        ImmutableSortedMap.Builder p4ChangelistsBuilder = ImmutableSortedMap.naturalOrder();
        for (long changelistId : changelistIds) {
            Mockito.when((Object)repositoryInfo.isPathInRepo(Matchers.anyString(), Matchers.eq((long)changelistId))).thenReturn((Object)true);
            p4ChangelistsBuilder.put((Object)changelistId, (Object)new P4ChangeList(changelistId));
        }
        ImmutableSortedMap changeLists = p4ChangelistsBuilder.build();
        DiffTextCache diffTextCache = new DiffTextCache("repo", true);
        DescribeProcessor describeProcessor = new DescribeProcessor(repositoryInfo, (SortedMap)changeLists, describeType, diffTextCache);
        describeProcessor.processOutput((Watchdog)Mockito.mock(Watchdog.class), (InputStream)byteArrayInputStream, "UTF-8");
        return changeLists;
    }

    private static String getResourceAsString(String fileName) {
        URL resource = Resources.getResource(DescribeProcessorTest.class, (String)("data/" + fileName));
        try {
            return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

