/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.perforce.P4ChangeSetImpl;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchResults;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class SimpleJobTest
extends P4TestBase {
    @Override
    protected String getDumpName() {
        return "simplejob";
    }

    @Test
    public void testJobSlurping() throws DbException {
        P4ChangeSetImpl p4ChangeSet = this.cache.getChangeSet("1");
        HashSet fixes = new HashSet(p4ChangeSet.getFixes());
        junit.framework.Assert.assertEquals((String)"Number of fixes is incorrect", (int)1, (int)fixes.size());
        junit.framework.Assert.assertTrue((String)"Fix is incorrect", (boolean)fixes.contains("testjob"));
        p4ChangeSet = this.cache.getChangeSet("2");
        fixes = new HashSet(p4ChangeSet.getFixes());
        junit.framework.Assert.assertEquals((String)"Number of fixes is incorrect", (int)2, (int)fixes.size());
        junit.framework.Assert.assertTrue((String)"Fix is incorrect", (boolean)fixes.contains("CRU-1200"));
        junit.framework.Assert.assertTrue((String)"Fix is incorrect", (boolean)fixes.contains("really_long_job_name"));
    }

    @Test
    public void testFixesEyeQL() throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"CRU-1200\"");
        int size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        FileRevision rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"2", (String)rev.getChangeSetId());
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"Blah\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)size);
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"really_long_job_name\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        results = collator.iterateRevisions(0);
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"2", (String)rev.getChangeSetId());
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"testjob\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        results = collator.iterateRevisions(0);
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"1", (String)rev.getChangeSetId());
    }

    @Test
    public void testFixesRegexEyeQL() throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =~  \"CRU-[0-9]+\"");
        int size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        FileRevision rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"2", (String)rev.getChangeSetId());
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =~  \"Blah?\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)size);
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =~  \"(really_|long_|job_|name)+\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        results = collator.iterateRevisions(0);
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"2", (String)rev.getChangeSetId());
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =~  \"testjob\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        results = collator.iterateRevisions(0);
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect revision returned", (String)"1", (String)rev.getChangeSetId());
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =~  \".*\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)2, (int)size);
        results = collator.iterateRevisions(0);
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect csid", (String)"1", (String)rev.getChangeSetId());
        Set fixes = ((P4RevInfo)rev).getFixedJobs();
        junit.framework.Assert.assertTrue((String)("Changeset (fixes: " + fixes + ") doesn't fix testjob"), (boolean)fixes.contains("testjob"));
        rev = results.nextItem();
        junit.framework.Assert.assertEquals((String)"Incorrect csid", (String)"2", (String)rev.getChangeSetId());
        fixes = ((P4RevInfo)rev).getFixedJobs();
        junit.framework.Assert.assertTrue((String)("Changeset (fixes: " + fixes + ") doesn't fix CRU-1200"), (boolean)fixes.contains("CRU-1200"));
        junit.framework.Assert.assertTrue((String)("Changeset (fixes: " + fixes + ") doesn't fix really_long_job_name"), (boolean)fixes.contains("really_long_job_name"));
    }

    @Test
    public void testJobLoading() throws DbException {
        P4Job job = this.cache.getJob("CRU-1200");
        Assert.assertNotNull((Object)job);
        junit.framework.Assert.assertEquals((String)"User field not retrieved", (String)"conor", (String)job.getField("User"));
    }

    @Test
    public void testJobsFixedReturnClause() throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery("select revisions from dir / return csid, p4:jobsFixed");
        int size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)2, (int)size);
        SearchResults.TabularResultsIterator resultsIterator = collator.iterateData(0);
        SearchResults.ResultRow row0 = resultsIterator.nextRow();
        String[] jobsFixed0 = row0.getStringArray(1);
        junit.framework.Assert.assertEquals((int)1, (int)jobsFixed0.length);
        junit.framework.Assert.assertEquals((String)"testjob", (String)jobsFixed0[0]);
        SearchResults.ResultRow row1 = resultsIterator.nextRow();
        String[] jobsFixed1 = row1.getStringArray(1);
        HashSet<String> fixedJobs = new HashSet<String>();
        fixedJobs.addAll(Arrays.asList(jobsFixed1));
        junit.framework.Assert.assertEquals((int)2, (int)fixedJobs.size());
        junit.framework.Assert.assertTrue((boolean)fixedJobs.contains("CRU-1200"));
        junit.framework.Assert.assertTrue((boolean)fixedJobs.contains("really_long_job_name"));
    }

    @Test
    public void testChangesetSearch() {
        RecentChangesSearcher2 recentChangesSearcher2 = new RecentChangesSearcher2((InternalRevisionCache)this.cache);
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setP4JobFixed("CRU-1200");
        System.out.println(recentChangesSearcher2.findRecentChangeSets(params));
    }
}

