/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputProcessor;
import com.cenqua.fisheye.search.SearchResults;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RescanTest
extends P4TestBase {
    private P4Exec p4Exec;
    private P4Client p4Client;

    @Override
    protected String getDumpName() {
        return "basic";
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.p4Client = this.getCache().allocateClient();
        Field execField = P4Client.class.getDeclaredField("exec");
        execField.setAccessible(true);
        this.p4Exec = (P4Exec)execField.get(this.p4Client);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getCache().returnClient(this.p4Client);
        super.tearDown();
    }

    @Test
    public void testRescan() throws Exception {
        Object engine = this.testHarness.getEngine();
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(engine);
        RecentChangesParams2 params = new RecentChangesParams2();
        List changeSets = searcher.findRecentChangeSets(params);
        junit.framework.Assert.assertEquals((int)4, (int)changeSets.size());
        SearchResults collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"FE-868\"");
        int size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)size);
        this.createTestJob("FE-868");
        this.fix(4L, "FE-868");
        engine.rescan("4", "4");
        collator = this.testHarness.evaluateQuery("select revisions from dir / where p4:jobid =  \"FE-868\"");
        size = collator.size();
        junit.framework.Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        changeSets = searcher.findRecentChangeSets(params);
        junit.framework.Assert.assertEquals((int)4, (int)changeSets.size());
    }

    @Test
    public void rescanShouldOnlyReindexRequestedChangelists() throws Exception {
        this.getEngine().rescan("3", "4");
        AtomicBoolean testsRan = new AtomicBoolean(false);
        this.getEngine().getCrossRepLuceneIndex().getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, indexSearcher -> {
            DocInfoManager man = new DocInfoManager(null, indexSearcher.getIndexReader());
            List reindexedCsDocs = man.findDocs(((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).indexedBetween(Long.MIN_VALUE, 0L)).build(), ChangesetDocInfo.CONVERTER_CSID_ONLY, Integer.MAX_VALUE);
            List allCsDocs = man.findDocs(((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).build(), ChangesetDocInfo.CONVERTER_CSID_ONLY, Integer.MAX_VALUE);
            MatcherAssert.assertThat((Object)reindexedCsDocs, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"3", "4"}));
            MatcherAssert.assertThat((Object)allCsDocs, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"1", "2", "3", "4"}));
            testsRan.set(true);
            return null;
        });
        Assert.assertTrue((boolean)testsRan.get());
    }

    public void createTestJob(String jobName) throws P4ClientException {
        String input;
        List command = P4CliUtils.tokenizeCommand((String)"job -i");
        String status = this.p4Exec.executeCommand(command, input = "Job: " + jobName + "\nStatus: open\nUser: testUser\nDescription:\n Test Job", (P4OutputProcessor)new P4OutputLineProcessor(){

            public void processLine(String infoLine, int counter) throws P4ClientException {
            }
        });
        if (status != null) {
            throw new P4ClientException("Exception creating job " + status);
        }
    }

    public void fix(long changeList, String ... jobs) throws P4ClientException {
        StringBuilder commandStr = new StringBuilder("fix ");
        commandStr.append("-c ").append(changeList);
        for (String job : jobs) {
            commandStr.append(" ").append(job);
        }
        List command = P4CliUtils.tokenizeCommand((String)commandStr.toString());
        String status = this.p4Exec.executeCommand(command, null, (P4OutputProcessor)new P4OutputLineProcessor(){

            public void processLine(String infoLine, int counter) throws P4ClientException {
            }
        });
        if (status != null) {
            throw new P4ClientException("Exception applying fixes " + status);
        }
    }
}

