/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PerforceLinecountTest
extends P4TestBase {
    private BucketGraph dataCollector;
    Path path = new Path((CharSequence)"CleanSweeper.java");
    private TimeZone tzOrig = TimeZone.getDefault();
    private TimeZone tzOrigConfig = TimeZone.getDefault();

    @Override
    @Before
    public void setUp() throws Exception {
        System.out.println("Original default timezone: " + this.tzOrig);
        TimeZone.setDefault(TimeZone.getTimeZone("Australia/Sydney"));
        System.out.println("New default timezone: " + TimeZone.getDefault());
        if (AppConfig.getsConfig() != null) {
            this.tzOrigConfig = AppConfig.getsConfig().getTimezone();
            System.out.println("Original config timezone: " + this.tzOrigConfig);
            if (AppConfig.getsConfig().getConfigDocument() != null) {
                AppConfig.getsConfig().getConfig().setTimezone("Australia/Sydney");
                AppConfig.getsConfig().reload();
                System.out.println("Original config timezone: " + this.tzOrigConfig);
            } else {
                AppConfig.getsConfig().setTimezone(TimeZone.getTimeZone("Australia/Sydney"));
                System.out.println("AppConfig.getsConfig().getConfigDocument()==null");
            }
        } else {
            System.out.println("AppConfig.getsConfig() == null");
        }
        super.setUp();
        this.dataCollector = this.getEngine().getBucketGraph();
        this.dataCollector.reindex(this.getEngine().getLinecountCalculator(), this.getEngine().getStatus());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        TimeZone.setDefault(this.tzOrig);
        if (AppConfig.getsConfig() != null && AppConfig.getsConfig().getConfigDocument() != null) {
            AppConfig.getsConfig().getConfig().setTimezone(this.tzOrigConfig.getID());
            AppConfig.getsConfig().reload();
        } else if (AppConfig.getsConfig() != null) {
            AppConfig.getsConfig().setTimezone(this.tzOrigConfig);
        }
        super.tearDown();
    }

    @Override
    protected String getDumpName() {
        return "basic";
    }

    @Test
    public void testBucketLinecount() throws Exception {
        FileRevision rev1 = this.cache.getFileRevision(1);
        System.out.println(rev1.getDate() + " " + new Period(PeriodUnit.DAY, new Date(rev1.getDate()), TimeZone.getDefault()));
        System.out.println("Bucket timezone: " + this.dataCollector.getTimeZone());
        Assert.assertEquals((String)this.dataCollector.toStringFull(), (String)"\n cache [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \n cache [__TRUNKLIKE__, .txt, conor] 0-13368=[1,1] 0-13371=[3,3] \n cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \n cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[3,3] \n cache [head, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \n cache [head, .txt, conor] 0-13368=[1,1] 0-13371=[3,3] \n cache [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \n cache [head, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [__TRUNKLIKE__, .txt, conor] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [head, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [head, .txt, conor] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[3,3] \ntest cache [head, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[3,3] \ntest/test.txt data [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [__TRUNKLIKE__, .txt, conor] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [head, .txt, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [head, .txt, conor] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13368=[1,1] 0-13371=[1,1] \ntest/test.txt data [head, __ALL_EXTENSIONS__, conor] 0-13368=[1,1] 0-13371=[1,1] \ntest/test2.txt data [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 0-13371=[2,2] \ntest/test2.txt data [__TRUNKLIKE__, .txt, conor] 0-13371=[2,2] \ntest/test2.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13371=[2,2] \ntest/test2.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 0-13371=[2,2] \ntest/test2.txt data [head, .txt, __ALL_AUTHORS__] 0-13371=[2,2] \ntest/test2.txt data [head, .txt, conor] 0-13371=[2,2] \ntest/test2.txt data [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-13371=[2,2] \ntest/test2.txt data [head, __ALL_EXTENSIONS__, conor] 0-13371=[2,2] ");
    }
}

