/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4TestBase;
import junit.framework.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;

public class P4UnpassivateTest
extends P4TestBase {
    @Rule
    public RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Override
    protected String getDumpName() {
        return "p4unpassivate1";
    }

    @Test
    public void testUnpassivateOnChange() throws Exception {
        System.setProperty("atlassian.fecru.dev.mode", "true");
        P4RepositoryEngine engine = (P4RepositoryEngine)this.testHarness.getEngine();
        engine.passivate();
        Assert.assertFalse((String)"DB failed to passivate", (boolean)((P4Cache)engine.getInternalRevisionCache()).getInfDb().isOpen());
        engine.slurp();
        if (((P4Cache)engine.getInternalRevisionCache()).getInfDb().isOpen()) {
            ((P4Cache)engine.getInternalRevisionCache()).getInfDb().getOpenTrace().printStackTrace();
        }
        Assert.assertFalse((String)"DB was opened by slurp", (boolean)((P4Cache)engine.getInternalRevisionCache()).getInfDb().isOpen());
        this.testHarness.doIncSlurp(this.findDump("p4unpassivate2"));
        Assert.assertTrue((String)"DB failed to open on change", (boolean)((P4Cache)engine.getInternalRevisionCache()).getInfDb().isOpen());
    }
}

