/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4LineToFieldProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4ZTagExtractor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class P4TestUtils {
    public static final String P4_OUTPUT_FILEDIR = "test/testfiles/p4/output/";

    public static void pumpZTagProcessor(String file, String keyTag, P4ZTagProcessor processor) throws IOException, P4ClientException {
        P4ZTagExtractor extractor = new P4ZTagExtractor(keyTag, processor);
        P4TestUtils.pumpLineProcessor(file, (P4OutputLineProcessor)extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pumpLineProcessor(String file, P4OutputLineProcessor processor) throws P4ClientException, IOException {
        File contentFile = new File(FisheyeTestEnv.WORKSPACE_DIR, P4_OUTPUT_FILEDIR + file);
        BufferedReader br = new BufferedReader(new FileReader(contentFile));
        try {
            String line;
            int count = 0;
            while ((line = br.readLine()) != null) {
                processor.processLine(line, count++);
            }
            processor.complete();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{br});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{br});
    }

    public static void pumpFieldProcessor(String file, P4FieldProcessor processor) throws IOException, P4ClientException {
        P4TestUtils.pumpLineProcessor(file, (P4OutputLineProcessor)new P4LineToFieldProcessor(false, processor));
    }
}

