/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fecru.upgrade.DefaultUpgradeManager;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.rep.ScannerTestHarness;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.perforce.client.P4Server;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.ZipException;
import org.apache.xmlbeans.XmlException;

public class P4TestHarness
extends ScannerTestHarness<P4RepositoryEngine, P4Scanner> {
    private static final String CHECKPOINT_NAME = "checkpoint.1";
    private P4Server server = new P4Server();
    private int serverPort = 6001;
    private boolean caseSensitive;
    private String charset;
    private boolean unicode;

    public P4TestHarness() {
        String p4Exe;
        String p4dExe = System.getProperty("p4d.exe");
        if (!Strings.isNullOrEmpty((String)p4dExe)) {
            P4Server.setP4dExecutable(p4dExe);
        }
        if (!Strings.isNullOrEmpty((String)(p4Exe = System.getProperty("p4.exe")))) {
            P4Exec.setP4Executable((String)p4Exe);
        }
    }

    @Override
    protected P4RepositoryEngine createEngine() throws XmlException, IOException, ConfigException, DbException {
        RepositoryType repoDef = this.createP4RepoDefinition();
        P4ScmConfig p4Config = new P4ScmConfig(repoDef.getName(), null, (RepositorySystemType)repoDef.getPerforce());
        RepositoryConfig config = new RepositoryConfig(this.getRootConfig(), repoDef, (ScmConfig)p4Config, (LicenseEnforcer)new NullLicenseEnforcer(), null);
        UpgradeManager upgradeManager = DefaultUpgradeManager.getInstance();
        return (P4RepositoryEngine)config.createRepositoryEngine(upgradeManager, this.getIndexingContext());
    }

    protected P4Cache getRevisionCache() {
        return (P4Cache)((P4RepositoryEngine)this.getEngine()).getRevisionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterEngineStarted() throws DbException {
        P4Client client = this.getRevisionCache().allocateClient();
        try {
            client.info();
        }
        catch (P4ClientException e) {
            try {
                Logs.APP_LOG.warn((Object)"Error trying to get client info - waiting 10 secs");
                Thread.sleep(10000L);
                client.info();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (P4ClientException e2) {
                System.out.println("Server failure:\noutput = " + this.server.getOutput() + "\nerror = " + this.server.getError());
                throw new RuntimeException("Server failed to run", e2);
            }
        }
        finally {
            this.getRevisionCache().returnClient(client);
        }
    }

    @Override
    protected void restoreDump(File dumpDir, File repoLocation) throws IOException, RepositoryClientException {
        File depotZip;
        boolean wasEngineRunning;
        boolean bl = wasEngineRunning = this.engine != null;
        if (wasEngineRunning) {
            this.stopRepo();
            this.waitForPortOpen(false);
            IOHelper.recursiveDelete((File)repoLocation, (int)Integer.MAX_VALUE);
        }
        if ((depotZip = new File(dumpDir, "depot.zip")).exists()) {
            File checkpoint = new File(dumpDir, CHECKPOINT_NAME);
            repoLocation.mkdirs();
            IOHelper.copy((File)checkpoint, (File)repoLocation);
            try {
                IOHelper.unzip((File)depotZip, (File)repoLocation);
            }
            catch (ZipException zipException) {}
        } else {
            IOHelper.copyDir((File)dumpDir, (File)repoLocation);
        }
        File journalFile = new File(repoLocation, "journal");
        if (!IOHelper.touch((File)journalFile)) {
            throw new IOException("Unable to touch journal file: " + journalFile.getAbsolutePath());
        }
        if (wasEngineRunning) {
            this.startRepo();
            this.waitForPortOpen(true);
        }
    }

    private void waitForPortOpen(boolean shouldBeOpen) throws IOException {
        boolean isOpen;
        int maxRepeat = 50;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                new Socket("localhost", this.serverPort).close();
                isOpen = true;
            }
            catch (SocketException e) {
                isOpen = false;
            }
            if (maxRepeat-- > 0) continue;
            throw new IllegalStateException("Failed waiting for perforce server");
        } while (shouldBeOpen != isOpen);
    }

    @Override
    protected void startRepo() throws RepositoryClientException {
        this.server.setServerPort(this.serverPort);
        this.server.setServerRoot(this.getRepoDir());
        this.server.loadCheckpoint(CHECKPOINT_NAME);
        this.server.start(this.unicode);
    }

    @Override
    protected void stopRepo() {
        this.server.stop(this.unicode);
    }

    public RepositoryType createP4RepoDefinition() throws IOException, XmlException {
        RepositoryType repoDefinition = this.createRepoDefinition();
        P4RepType p4 = repoDefinition.addNewPerforce();
        p4.setServer("localhost");
        p4.setPort(BigInteger.valueOf(this.serverPort));
        String basePath = "//depot";
        if (this.getSubPath() != null) {
            basePath = basePath + this.getSubPath();
        }
        p4.setPath(basePath);
        p4.setCasesensitive(this.caseSensitive);
        if (this.charset != null) {
            p4.setCharset(this.charset);
        }
        p4.setUnicode(this.unicode);
        if (this.getUsername() != null) {
            UserPassAuthType p4Auth = p4.addNewAuth();
            p4Auth.setUsername(this.getUsername());
            if (this.getPassword() != null) {
                p4Auth.setPassword(this.getPassword());
            }
        }
        return repoDefinition;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }
}

