/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.P4TestHarness;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;

public abstract class P4TestBase
extends SpringIntegrationTestBase {
    protected P4Cache cache;
    protected P4TestHarness testHarness;

    @Before
    public void setUp() throws Exception {
        try {
            AppConfig.setTestMode();
            this.testHarness = this.createHarness();
            File dump = this.findDump(this.getDumpName());
            boolean storeDiffs = this.getStoreDiffs();
            String charset = this.getCharset();
            AppConfig.getsConfig().initCrossRepLuceneIndex();
            this.testHarness.setSubPath(this.getSubPath());
            this.testHarness.setAllow(this.getAllowRules());
            this.testHarness.setCaseSensitive(this.getCaseSensitive());
            this.testHarness.setStoreDiffs(storeDiffs);
            this.testHarness.setCharset(charset);
            this.testHarness.setUsername(this.getUsername());
            this.testHarness.setPassword(this.getPassword());
            this.testHarness.setUnicode(this.getUnicode());
            this.testHarness.slurpDump(dump);
            this.testHarness.assertNoSlurpErrors(dump.getAbsolutePath());
            this.cache = (P4Cache)((P4Scanner)this.testHarness.getScanner()).getCache();
        }
        catch (Throwable t) {
            this.tearDown();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    protected File findDump(String dumpName) {
        return new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/p4/dumps/" + dumpName);
    }

    protected P4TestHarness createHarness() {
        return new P4TestHarness();
    }

    protected boolean getUnicode() {
        return false;
    }

    protected String getCharset() {
        return null;
    }

    public RepositoryEngine getEngine() {
        return this.testHarness.getEngine();
    }

    public P4Cache getCache() {
        return this.cache;
    }

    protected boolean getCaseSensitive() {
        return true;
    }

    protected boolean getStoreDiffs() {
        return true;
    }

    protected long getStartRev() {
        return 0L;
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.cleanUp();
    }

    protected abstract String getDumpName();

    protected AllowType getAllowRules() {
        return null;
    }

    protected String getSubPath() {
        return null;
    }

    protected void assertContainsRevs(String query, int expectedSize, int[] changeSetIds) throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery(query);
        int size = collator.size();
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        HashMap<String, FileRevision> revs = new HashMap<String, FileRevision>();
        while (results.hasNext()) {
            FileRevision rev = results.nextItem();
            revs.put(rev.getChangeSetId(), rev);
        }
        if (expectedSize != -1) {
            Assert.assertEquals((String)("Result size of query '" + query + "' not correct"), (int)expectedSize, (int)size);
        }
        if (size != 0) {
            for (int changeSetId : changeSetIds) {
                Assert.assertTrue((String)("Result of query '" + query + "' does not contain expected revision: " + changeSetId), (boolean)revs.containsKey(Integer.toString(changeSetId)));
            }
        }
    }

    protected void assertContent(Path path, long revision, String expectedContent) throws IOException, DbException {
        String resultLine;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        RevInfoKey key = new RevInfoKey(path, Long.toString(revision));
        this.cache.getTextRevision(key, (OutputStream)stream, null);
        String result = new String(stream.toByteArray());
        BufferedReader resultReader = new BufferedReader(new StringReader(result));
        BufferedReader expectedReader = new BufferedReader(new StringReader(expectedContent));
        int lineCount = 0;
        while ((resultLine = resultReader.readLine()) != null) {
            String expectedLine = expectedReader.readLine();
            Assert.assertNotNull((String)("Expected content of " + path + "@" + revision + " was smaller than result at line " + ++lineCount), (Object)expectedLine);
            Assert.assertEquals((String)("Content mismatch of " + path + "@" + revision + " at line " + lineCount), (String)expectedLine, (String)resultLine);
        }
        Assert.assertNull((String)("Expected content of " + path + "@" + revision + " is longer than result at line " + lineCount), (Object)expectedReader.readLine());
    }

    protected Map<String, ChangeSet> getChangeSetMap(List<ChangeSet> changeSets) {
        HashMap<String, ChangeSet> changeSetsById = new HashMap<String, ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            changeSetsById.put(changeSet.getId(), changeSet);
        }
        return changeSetsById;
    }

    protected Blame assertBlame(Path path, int revision, int blameSize) throws DbException, IOException {
        RevInfoKey key = new RevInfoKey(path, Long.toString(revision));
        Blame blame = this.cache.getBlame(key);
        Assert.assertNotNull((String)("No blame found for " + key), (Object)blame);
        Assert.assertEquals((String)("Incorrect number of blame chunks for " + key), (int)blameSize, (int)blame.getChunks().size());
        return blame;
    }

    public static boolean isFilesystemCaseSensitive() {
        try {
            File testFile = File.createTempFile("Blah", "");
            File lcFile = new File(testFile.getCanonicalPath().toLowerCase());
            boolean caseSensitive = !lcFile.exists();
            testFile.delete();
            return caseSensitive;
        }
        catch (IOException e) {
            return true;
        }
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    protected void assertBlameMetrics(String pathStr, int revNum, int numLines) throws DbException, IOException {
        Path path = new Path((CharSequence)pathStr);
        RevInfoKey key = new RevInfoKey(path, Integer.toString(revNum));
        FileRevision rev = this.cache.getFileRevision(key);
        Assert.assertFalse((String)("File was not indicated as text for " + pathStr + "@" + revNum), (boolean)rev.isBinary());
        Assert.assertEquals((String)("Incorrect Line Count for " + pathStr + "@" + revNum), (int)numLines, (int)rev.getLineCount());
        Blame blame = this.cache.getBlame(key);
        List chunks = blame.getChunks();
        Assert.assertEquals((String)("Blame size incorrect for " + pathStr + "@" + revNum), (int)1, (int)chunks.size());
        BlameChunk chunk1 = (BlameChunk)chunks.get(0);
        Assert.assertEquals((String)("Blame num lines for " + pathStr + "@" + revNum), (int)numLines, (int)chunk1.getLength());
        blame = this.cache.getBlameFallback(key);
        chunks = blame.getChunks();
        Assert.assertEquals((String)("Blame fallback size incorrect for " + pathStr + "@" + revNum), (int)1, (int)chunks.size());
        chunk1 = (BlameChunk)chunks.get(0);
        Assert.assertEquals((String)("Blame fallback num lines for " + pathStr + "@" + revNum), (int)numLines, (int)chunk1.getLength());
    }

    protected void assertDiffMetrics(String pathStr, int revNum, int numLines, int numAdded, int numRemoved) throws DbException {
        Path path = new Path((CharSequence)pathStr);
        RevInfoKey key = new RevInfoKey(path, Integer.toString(revNum));
        FileRevision rev = this.cache.getFileRevision(key);
        if (rev == null) {
            Assert.fail((String)("Could not find " + pathStr + "@" + revNum));
        }
        Assert.assertFalse((String)("File was not indicated as text for " + pathStr + "@" + revNum), (boolean)rev.isBinary());
        Assert.assertEquals((String)("Incorrect Line Count for " + pathStr + "@" + revNum), (int)numLines, (int)rev.getLineCount());
        Assert.assertEquals((String)("Incorrect Added Line Count for " + pathStr + "@" + revNum), (int)numAdded, (int)rev.getLinesAdded());
        Assert.assertEquals((String)("Incorrect Removed Line Count for " + pathStr + "@" + revNum), (int)numRemoved, (int)rev.getLinesRemoved());
    }

    protected void assertFileMetrics(String pathString, int revNum, int numLines, int numAdded, int numRemoved) throws IOException, DbException {
        this.assertDiffMetrics(pathString, revNum, numLines, numAdded, numRemoved);
        this.assertBlameMetrics(pathString, revNum, numLines);
    }
}

