/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.rep.IndexingContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class P4ScannerTest {
    private final P4RepositoryEngine engine = (P4RepositoryEngine)Mockito.mock(P4RepositoryEngine.class);
    private final RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
    private final P4Cache cache = (P4Cache)Mockito.mock(P4Cache.class);
    private final P4RepositoryInfo p4RepInfo = (P4RepositoryInfo)Mockito.mock(P4RepositoryInfo.class);
    private final IndexingContext indexingContext = (IndexingContext)Mockito.mock(IndexingContext.class);
    private P4Scanner scanner;
    private P4Client p4Client = (P4Client)Mockito.mock(P4Client.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.engine.getRepoInfo()).thenReturn((Object)this.p4RepInfo);
        Mockito.when((Object)this.engine.getCfg()).thenReturn((Object)this.config);
        Mockito.when((Object)this.engine.getIndexingContext()).thenReturn((Object)this.indexingContext);
        Mockito.when((Object)this.cache.allocateClient()).thenReturn((Object)this.p4Client);
        this.scanner = new P4Scanner(this.engine);
        this.scanner.start(this.cache);
    }

    @Test
    public void testStop_shouldNotAllocateClient() throws Exception {
        this.scanner.client = null;
        this.scanner.stop();
        ((P4Cache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.times((int)0))).allocateClient();
    }

    @Test
    public void testGetClient() throws Exception {
        this.scanner.client = null;
        this.scanner.getClient();
        Assert.assertThat((Object)this.scanner.client, (Matcher)CoreMatchers.instanceOf(P4Client.class));
    }
}

