/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.event.CommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.rep.RepositoryEventCollector;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.perforce.P4TestHarness;
import com.cenqua.fisheye.rep.BranchChange;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class P4RepositoryScanProcessedEventTest
extends P4TestBase {
    private static final String INITIAL_REPO = "ancestry";
    private static final String INCREMENTAL_REPO = "test/testfiles/p4/dumps/ancestry-scanprocessed";
    private RepositoryEventCollector eventCollector = new RepositoryEventCollector();

    @Override
    protected String getDumpName() {
        return INITIAL_REPO;
    }

    @Override
    protected P4TestHarness createHarness() {
        return new P4TestHarness(){

            @Override
            protected void beforeEngineStarted() {
                super.beforeEngineStarted();
                this.registerCommitEventGenerator();
                this.getEventPublisher().register((Object)P4RepositoryScanProcessedEventTest.this.eventCollector);
            }
        };
    }

    @Test
    public void testScanProcessedEvent() throws Exception {
        List<Object> eventsAfterInitial = this.eventCollector.getAndClearEvents();
        this.testHarness.doIncSlurp(new File(INCREMENTAL_REPO));
        List<Object> eventsAfterIncremental = this.eventCollector.getAndClearEvents();
        this.testHarness.doIncSlurp(new File(INCREMENTAL_REPO));
        List<Object> eventsAfterSubsequent = this.eventCollector.getAndClearEvents();
        Assert.assertThat(eventsAfterInitial, (Matcher)Matchers.empty());
        Assert.assertThat(eventsAfterIncremental, (Matcher)Matchers.contains((Object[])new Object[]{new CommitEventImpl(this.getEngine().getName(), "16"), new CommitEventImpl(this.getEngine().getName(), "17"), new RepositoryScanProcessedEvent(this.getEngine().getName(), (Iterable)ImmutableSet.of((Object)"16", (Object)"17"), (Iterable)ImmutableSet.of((Object)new BranchChange("branch_a", BranchChange.ChangeType.MODIFIED), (Object)new BranchChange("branch_new", BranchChange.ChangeType.ADDED)))}));
        Assert.assertThat(eventsAfterSubsequent, (Matcher)Matchers.empty());
    }
}

