/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4RepoBranches;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class P4RepoBranchesTest {
    public P4RepoBranches createP4RepoBranches(final Map<String, Long> initialBranchTimes, Map<String, Long> branchTimesFromClient, final Map<String, Long> storedBranchTimes, Set<String> fetchedBranches, Set<String> branchesInRepo, final Collection<P4BranchSpec> initialBranchSpecs) throws Exception {
        P4RepositoryInfo repositoryInfo = (P4RepositoryInfo)Mockito.mock(P4RepositoryInfo.class);
        Mockito.when((Object)repositoryInfo.isCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)repositoryInfo.isPathInRepo(Matchers.anyString(), Matchers.anyLong())).thenAnswer(invocation -> branchesInRepo.contains((String)invocation.getArguments()[0]));
        RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        Mockito.when((Object)config.getStatus()).thenReturn((Object)new RepositoryStatus("foo"));
        P4Client client = (P4Client)Mockito.mock(P4Client.class);
        Mockito.when((Object)client.getBranchUpdateTimes()).thenReturn(branchTimesFromClient);
        Mockito.when((Object)client.getBranchSpec(Matchers.anyString())).thenAnswer(invocation -> {
            String branchName = (String)invocation.getArguments()[0];
            fetchedBranches.add(branchName);
            return this.makeBranchSpec(branchName);
        });
        P4Scanner scanner = (P4Scanner)Mockito.mock(P4Scanner.class);
        Mockito.when((Object)scanner.getClient()).thenReturn((Object)client);
        Mockito.when((Object)scanner.getRepositoryInfo()).thenReturn((Object)repositoryInfo);
        Mockito.when((Object)scanner.getStatus()).thenReturn((Object)new RepositoryStatus("foo"));
        P4RevInfoDAO fileRevDao = new P4RevInfoDAO(null, null, false, null, null){

            public void loadBranches(Map<String, Long> branchTimes, List<P4BranchSpec> branchSpecs) {
                branchTimes.putAll(initialBranchTimes);
                branchSpecs.addAll(initialBranchSpecs);
            }

            public void storeBranch(P4BranchSpec branchSpec, long newTime) {
                storedBranchTimes.put(branchSpec.getName(), newTime);
            }
        };
        return new P4RepoBranches(fileRevDao, scanner){};
    }

    private P4BranchSpec makeBranchSpec(String branchName) {
        P4BranchSpec spec = new P4BranchSpec(branchName);
        spec.addMapping(new P4BranchMapping(false, branchName, branchName));
        return spec;
    }

    @Test
    public void testTimeStampsAreHonouredAndUnmodifiedBranchesAreNotScannedAtStartup() throws Exception {
        HashMap<String, Long> initialBranchTimes = new HashMap<String, Long>();
        HashMap<String, Long> branchTimesFromClient = new HashMap<String, Long>();
        HashMap<String, Long> storedBranchTimes = new HashMap<String, Long>();
        HashSet<String> fetchedBranches = new HashSet<String>();
        HashSet<String> branchesInRepo = new HashSet<String>();
        List<P4BranchSpec> initialBranchSpecs = Arrays.asList(this.makeBranchSpec("baz"));
        initialBranchTimes.put("baz", 1L);
        branchTimesFromClient.put("foo", 1L);
        branchTimesFromClient.put("bar", 2L);
        branchTimesFromClient.put("baz", 1L);
        branchesInRepo.add("foo");
        branchesInRepo.add("bar");
        branchesInRepo.add("baz");
        P4RepoBranches scanner = this.createP4RepoBranches(initialBranchTimes, branchTimesFromClient, storedBranchTimes, fetchedBranches, branchesInRepo, initialBranchSpecs);
        scanner.updateBranchMappings();
        Assert.assertEquals((int)2, (int)storedBranchTimes.size());
        Assert.assertEquals((long)1L, (long)((Long)storedBranchTimes.get("foo")));
        Assert.assertEquals((long)2L, (long)((Long)storedBranchTimes.get("bar")));
        Assert.assertEquals((int)2, (int)fetchedBranches.size());
        initialBranchTimes.put("foo", 1L);
        initialBranchTimes.put("bar", 2L);
        branchTimesFromClient.put("foo", 1L);
        branchTimesFromClient.put("bar", 3L);
        storedBranchTimes.clear();
        fetchedBranches.clear();
        scanner.updateBranchMappings();
        Assert.assertEquals((int)1, (int)storedBranchTimes.size());
        Assert.assertEquals((long)3L, (long)((Long)storedBranchTimes.get("bar")));
        Assert.assertEquals((int)1, (int)fetchedBranches.size());
        Assert.assertTrue((boolean)fetchedBranches.contains("bar"));
    }

    @Test
    public void testOutOfRepoBranchesAreScannedOnceOnly() throws Exception {
        HashMap<String, Long> initialBranchTimes = new HashMap<String, Long>();
        HashMap<String, Long> branchTimesFromClient = new HashMap<String, Long>();
        HashMap<String, Long> storedBranchTimes = new HashMap<String, Long>();
        HashSet<String> fetchedBranches = new HashSet<String>();
        HashSet<String> branchesInRepo = new HashSet<String>();
        List<P4BranchSpec> initialBranchSpecs = Arrays.asList(this.makeBranchSpec("baz"));
        initialBranchTimes.put("baz", 1L);
        branchTimesFromClient.put("foo", 1L);
        branchTimesFromClient.put("baz", 1L);
        P4RepoBranches scanner = this.createP4RepoBranches(initialBranchTimes, branchTimesFromClient, storedBranchTimes, fetchedBranches, branchesInRepo, initialBranchSpecs);
        scanner.updateBranchMappings();
        Assert.assertEquals((int)1, (int)storedBranchTimes.size());
        Assert.assertEquals((long)1L, (long)((Long)storedBranchTimes.get("foo")));
        Assert.assertEquals((int)1, (int)fetchedBranches.size());
        initialBranchTimes.put("baz", 1L);
        initialBranchTimes.put("foo", 1L);
        branchTimesFromClient.put("baz", 1L);
        branchTimesFromClient.put("foo", 2L);
        storedBranchTimes.clear();
        fetchedBranches.clear();
        scanner.updateBranchMappings();
        Assert.assertEquals((int)1, (int)storedBranchTimes.size());
        Assert.assertEquals((long)2L, (long)((Long)storedBranchTimes.get("foo")));
        Assert.assertEquals((int)1, (int)fetchedBranches.size());
    }

    @Test
    public void testBranchesWithTimestampsButNoBranchSpecAreScanned() throws Exception {
        HashMap<String, Long> initialBranchTimes = new HashMap<String, Long>();
        HashMap<String, Long> branchTimesFromClient = new HashMap<String, Long>();
        HashMap<String, Long> storedBranchTimes = new HashMap<String, Long>();
        HashSet<String> fetchedBranches = new HashSet<String>();
        HashSet<String> branchesInRepo = new HashSet<String>();
        ArrayList initialBranchSpecs = Lists.newArrayList();
        initialBranchTimes.put("baz", 1L);
        branchTimesFromClient.put("foo", 1L);
        branchTimesFromClient.put("bar", 2L);
        branchTimesFromClient.put("baz", 1L);
        branchesInRepo.add("foo");
        branchesInRepo.add("bar");
        branchesInRepo.add("baz");
        P4RepoBranches scanner = this.createP4RepoBranches(initialBranchTimes, branchTimesFromClient, storedBranchTimes, fetchedBranches, branchesInRepo, initialBranchSpecs);
        scanner.updateBranchMappings();
        Assert.assertEquals((int)3, (int)storedBranchTimes.size());
        Assert.assertEquals((long)1L, (long)((Long)storedBranchTimes.get("foo")));
        Assert.assertEquals((long)2L, (long)((Long)storedBranchTimes.get("bar")));
        Assert.assertEquals((long)1L, (long)((Long)storedBranchTimes.get("baz")));
        Assert.assertEquals((int)3, (int)fetchedBranches.size());
    }
}

