/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.P4MultiLineCountStream;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Test;
import org.mockito.Mockito;

public class P4MultiLineCountStreamTest {
    @Test
    public void shouldCountLinesInP4PrintOutput() throws Exception {
        P4FileSpec spec1 = new P4FileSpec("//depot/space file.txt", 1, 1);
        P4FileSpec spec2 = new P4FileSpec("//depot/file.txt", 1, 1);
        P4FileSpec spec3 = new P4FileSpec("//depot/space dir/test.txt", 1, 1);
        String p4printOutput = "//depot/space file.txt#1 - add change 3 (text)\nNew file\n//depot/file.txt#1 - add change 3 (text)\nNew file\n//depot/space dir/test.txt#1 - add change 3 (text)\nNew file\n";
        P4MultiLineCountStream.CountVisitor visitor = (P4MultiLineCountStream.CountVisitor)Mockito.mock(P4MultiLineCountStream.CountVisitor.class);
        P4MultiLineCountStream stream = new P4MultiLineCountStream(this.createFileMap(spec1, spec2, spec3), (DiffTextCache)Mockito.mock(DiffTextCache.class), 1L, visitor);
        this.parseString(stream, "//depot/space file.txt#1 - add change 3 (text)\nNew file\n//depot/file.txt#1 - add change 3 (text)\nNew file\n//depot/space dir/test.txt#1 - add change 3 (text)\nNew file\n");
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec1, 1);
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec2, 1);
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec3, 1);
    }

    @Test
    public void shouldCountLinesInEmptyFilesP4PrintOutput() throws Exception {
        P4FileSpec spec1 = new P4FileSpec("//depot/space file.txt", 1, 1);
        P4FileSpec spec2 = new P4FileSpec("//depot/file.txt", 1, 1);
        P4FileSpec spec3 = new P4FileSpec("//depot/space dir/test.txt", 1, 1);
        String p4printOutput = "//depot/space file.txt#1 - add change 3 (text)\n//depot/file.txt#1 - add change 3 (text)\nNew file\n//depot/space dir/test.txt#1 - add change 3 (text)\n";
        P4MultiLineCountStream.CountVisitor visitor = (P4MultiLineCountStream.CountVisitor)Mockito.mock(P4MultiLineCountStream.CountVisitor.class);
        P4MultiLineCountStream stream = new P4MultiLineCountStream(this.createFileMap(spec1, spec2, spec3), (DiffTextCache)Mockito.mock(DiffTextCache.class), 1L, visitor);
        this.parseString(stream, "//depot/space file.txt#1 - add change 3 (text)\n//depot/file.txt#1 - add change 3 (text)\nNew file\n//depot/space dir/test.txt#1 - add change 3 (text)\n");
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec1, 0);
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec2, 1);
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec3, 0);
    }

    @Test
    public void shouldCountLinesInP4PrintOutputWithSingleFile() throws Exception {
        P4FileSpec spec = new P4FileSpec("//depot/test/test.txt", 1, 1);
        String p4printOutput = "//depot/test/test.txt#1 - add change 1 (text)\nTest file\n";
        P4MultiLineCountStream.CountVisitor visitor = (P4MultiLineCountStream.CountVisitor)Mockito.mock(P4MultiLineCountStream.CountVisitor.class);
        P4MultiLineCountStream stream = new P4MultiLineCountStream(this.createFileMap(spec), (DiffTextCache)Mockito.mock(DiffTextCache.class), 1L, visitor);
        this.parseString(stream, "//depot/test/test.txt#1 - add change 1 (text)\nTest file\n");
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec, 1);
    }

    @Test
    public void shouldCountLinesInP4PrintWithoutEOLsAtEndOflines() throws Exception {
        P4FileSpec spec1 = new P4FileSpec("//depot/test.txt", 1, 1);
        P4FileSpec spec2 = new P4FileSpec("//depot/test2.txt", 1, 1);
        P4MultiLineCountStream.CountVisitor visitor = (P4MultiLineCountStream.CountVisitor)Mockito.mock(P4MultiLineCountStream.CountVisitor.class);
        P4MultiLineCountStream stream = new P4MultiLineCountStream(this.createFileMap(spec1, spec2), (DiffTextCache)Mockito.mock(DiffTextCache.class), 1L, visitor);
        String p4printOutput = "//depot/test.txt#1 - add change 3 (text)\nNew file//depot/test2.txt#1 - add change 3 (text)\nNew file";
        this.parseString(stream, "//depot/test.txt#1 - add change 3 (text)\nNew file//depot/test2.txt#1 - add change 3 (text)\nNew file");
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec1, 1);
        ((P4MultiLineCountStream.CountVisitor)Mockito.verify((Object)visitor)).visit(spec2, 1);
    }

    protected void parseString(P4MultiLineCountStream stream, String p4printOutput) throws IOException {
        ByteStreams.copy((InputStream)new ByteArrayInputStream(p4printOutput.getBytes(Charsets.UTF_8)), (OutputStream)stream);
        stream.close();
    }

    protected Map<P4FileSpec, P4ChangePath> createFileMap(P4FileSpec ... specs) {
        return Arrays.asList(specs).stream().collect(Collectors.toMap(Function.identity(), spec -> new P4ChangePath(spec)));
    }
}

