/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import junit.framework.Assert;
import org.junit.Test;

public class P4AuthorBlameTest
extends P4TestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected String getDumpName() {
        return "basic";
    }

    @Override
    protected boolean getStoreDiffs() {
        return true;
    }

    @Test
    public void testBucketLinecount() throws Exception {
        this.assertLinesAddedRemoved(1, 1, 0);
        this.assertLinesAddedRemoved(2, 1, 0);
        this.assertLinesAddedRemoved(3, 1, 0);
        this.assertLinesAddedRemoved(4, 1, 0);
    }

    private void assertLinesAddedRemoved(int revid, int expectedAdded, int expectedRemoved) throws DbException {
        FileRevision rev = this.getEngine().getRevisionCache().getFileRevision(revid);
        if (rev.getHunks() != null && !rev.getHunks().isEmpty()) {
            int added = 0;
            int removed = 0;
            for (Hunk hunk : rev.getHunks()) {
                added += hunk.getToCount();
                removed += hunk.getFromCount();
            }
            Assert.assertEquals((String)"rev.getLinesAdded() incorrect", (int)added, (int)rev.getLinesAdded());
            Assert.assertEquals((String)"rev.getLinesRemoved() incorrect", (int)removed, (int)rev.getLinesRemoved());
        }
        Assert.assertEquals((String)"rev.getLinesAdded() incorrect", (int)expectedAdded, (int)rev.getLinesAdded());
        Assert.assertEquals((String)"rev.getLinesRemoved() incorrect", (int)expectedRemoved, (int)rev.getLinesRemoved());
    }
}

