/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.perforce.P4AncestryTestBase;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4TestHarness;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

public class P4AncestryUpgradeTest
extends SpringIntegrationTestBase {
    private P4AncestryTestBase testBase;

    @Before
    public void setUp() throws Exception {
        AppConfig.setTestMode();
        this.testBase = new P4AncestryTestBase();
    }

    protected String getCacheDumpFile() {
        return "test/testfiles/p4/caches/p4ancestry-2.5.0.zip";
    }

    @Test
    public void testP4Upgrade() throws Exception {
        P4TestHarness harness = new P4TestHarness(){

            @Override
            public void startRepo() {
                P4AncestryUpgradeTest.this.unzipCache(this.getAppDir(), this.getRepoName());
            }

            @Override
            protected void stopRepo() {
            }

            @Override
            protected void afterEngineStarted() throws DbException {
            }
        };
        this.upgradeAndValidateAncestry(harness, "p4upgrade");
    }

    private void upgradeAndValidateAncestry(P4TestHarness harness, String repoName) throws Exception {
        try {
            AppConfig.getsConfig().initCrossRepLuceneIndex();
            harness.setRepoName(repoName);
            harness.createRepoDir();
            harness.createAndStartEngine();
            ((P4RepositoryEngine)harness.getEngine()).slurp();
            this.testBase.testBaseAncestry(((P4RepositoryEngine)harness.getEngine()).getRevisionCache());
            this.testBase.testExceptional(((P4RepositoryEngine)harness.getEngine()).getRevisionCache());
        }
        finally {
            harness.cleanUp();
        }
    }

    private void unzipCache(File appDir, String repoName) {
        try {
            File cacheDir = new File(appDir, "var/cache/" + repoName);
            System.out.println("Cache dir: " + cacheDir);
            IOHelper.mkdirs((File)cacheDir);
            String cacheZipName = this.getCacheDumpFile();
            File cacheZip = new File(FisheyeTestEnv.WORKSPACE_DIR, cacheZipName);
            IOHelper.unzip((File)cacheZip, (File)cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

