/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.AncestryTester;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangesetAncestryTester;
import com.cenqua.fisheye.rep.DbException;
import java.util.HashMap;
import java.util.Map;

public class P4AncestryTestBase {
    private static final Map<ChangesetAncestryTester.Action, String> CS_IDS = new HashMap<ChangesetAncestryTester.Action, String>();

    public void testBaseAncestry(RevisionCache cache) throws Exception {
        ChangesetAncestryTester tester = new ChangesetAncestryTester(cache){

            @Override
            public String getChangeSetId(ChangesetAncestryTester.Action action) {
                return (String)CS_IDS.get((Object)action);
            }
        };
        tester.verifyStraightCommitsOnMain();
        tester.verifyBranchOfMain();
        tester.verifyBranchOfBranch();
    }

    public void testExceptional(RevisionCache cache) throws DbException {
        this.verifyMultipleBranchCommit(cache);
        this.verifyComplexBranchCommit(cache);
        this.verifyNonAncestorBranchCommit(cache);
        this.verifyBranchDelete(cache);
    }

    private void verifyBranchDelete(RevisionCache cache) {
        ChangeSet branchDelete = cache.getChangeSet("15");
        AncestryTester.assertParents(cache, branchDelete, "14");
    }

    private void verifyNonAncestorBranchCommit(RevisionCache cache) {
        ChangeSet NonAncestorBranch = cache.getChangeSet("14");
        AncestryTester.assertParents(cache, NonAncestorBranch, new String[0]);
    }

    private void verifyComplexBranchCommit(RevisionCache cache) throws DbException {
        ChangeSet complexBranchCreateCS = cache.getChangeSet("13");
        AncestryTester.assertParents(cache, complexBranchCreateCS, "11", "12");
    }

    private void verifyMultipleBranchCommit(RevisionCache cache) throws DbException {
        ChangeSet multipleBranchCommitCS = cache.getChangeSet("10");
        AncestryTester.assertParents(cache, multipleBranchCommitCS, "6", "7");
    }

    static {
        CS_IDS.put(ChangesetAncestryTester.Action.MAIN_CREATE, "1");
        CS_IDS.put(ChangesetAncestryTester.Action.MAIN_ADD, "2");
        CS_IDS.put(ChangesetAncestryTester.Action.MAIN_EDIT_1, "3");
        CS_IDS.put(ChangesetAncestryTester.Action.BRANCH_A_CREATE, "4");
        CS_IDS.put(ChangesetAncestryTester.Action.BRANCH_A_EDIT, "6");
        CS_IDS.put(ChangesetAncestryTester.Action.BRANCH_B_CREATE, "5");
        CS_IDS.put(ChangesetAncestryTester.Action.BRANCH_B_EDIT, "7");
        CS_IDS.put(ChangesetAncestryTester.Action.BRANCH_A_A_CREATE, "8");
        CS_IDS.put(ChangesetAncestryTester.Action.TAG_1_CREATE, null);
        CS_IDS.put(ChangesetAncestryTester.Action.TAG_2_CREATE, null);
        CS_IDS.put(ChangesetAncestryTester.Action.MAIN_EDIT_2, "9");
    }
}

