/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class OddNamesTest
extends P4TestBase {
    @Override
    protected String getDumpName() {
        return "oddnames";
    }

    @Test
    public void testSpacePaths() throws IOException, DbException {
        Path path = new Path((CharSequence)"space file.txt");
        this.assertBlame(path, 4, 1);
        this.assertContent(path, 4L, "Modify empty file\n");
        path = new Path((CharSequence)"space dir/test.txt");
        this.assertBlame(path, 3, 1);
        this.assertContent(path, 3L, "New file\n");
        path = new Path((CharSequence)"test\".txt");
        FileHistory hist = this.cache.getFileHistory(path);
        Assert.assertNotNull((String)("History was null for " + path), (Object)hist);
        Assert.assertEquals((String)("History does not contain enough revisions for " + path), (int)2, (int)hist.getRevisions().size());
    }
}

