/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4TestUtils;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4Label;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import java.util.Map;
import org.junit.Test;

public class LabelParsingTest {
    @Test
    public void testLabelsParsing() throws Exception {
        P4ZTagProcessor processor = new P4ZTagProcessor(){

            public void processGroup(Map<String, String> labelProps) {
                P4Label label = new P4Label(labelProps.get("label"));
                label.setUpdateTime(Long.parseLong(labelProps.get("Update")));
                label.setAccessTime(Long.parseLong(labelProps.get("Access")));
                System.out.println("Label name is " + label.getName());
            }
        };
        P4TestUtils.pumpZTagProcessor("fsh2302.txt", "label", processor);
    }

    @Test
    public void testSingleParsing() throws Exception {
        P4ZTagProcessor processor = new P4ZTagProcessor(){

            public void processGroup(Map<String, String> labelProps) {
                String labelName = labelProps.get("Label");
                if (labelName != null) {
                    P4CliUtils.parseP4DateToTime((String)labelProps.get("Update"));
                    P4CliUtils.parseP4DateToTime((String)labelProps.get("Access"));
                } else {
                    Logs.APP_LOG.warn((Object)("Unable to label information labelProps = " + labelProps));
                }
            }
        };
        P4TestUtils.pumpZTagProcessor("fsh2302a.txt", null, processor);
    }
}

