/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class EOLHellTest
extends P4TestBase {
    @Override
    protected String getDumpName() {
        return "eolhell";
    }

    @Override
    protected boolean getStoreDiffs() {
        return true;
    }

    @Test
    public void testSlurp() throws DbException, IOException {
        Path path1 = new Path((CharSequence)"test.txt");
        Path path2 = new Path((CharSequence)"test2.txt");
        this.assertHunks(path1, 1, 1, 21);
        this.assertHunks(path1, 2, 1, 1);
        this.assertHunks(path1, 3, 1, -1);
        this.assertHunks(path1, 4, 1, 0);
        this.assertHunks(path1, 5, 3, 0);
        this.assertHunks(path1, 6, 1, 0);
        this.assertHunks(path1, 7, 1, -1);
        this.assertHunks(path1, 8, 1, 1);
        this.assertHunks(path2, 1, 1, 34);
        this.assertHunks(path2, 2, 1, 1);
        this.assertHunks(path2, 3, 1, -1);
        this.assertHunks(path2, 4, 1, 0);
        this.assertHunks(path2, 5, 3, 0);
        this.assertHunks(path2, 6, 1, 0);
        this.assertHunks(path2, 7, 1, -1);
        this.assertHunks(path2, 8, 1, 1);
    }

    private void assertHunks(Path path, int rev, int numHunks, int totalAdded) throws DbException {
        RevInfoKey key = new RevInfoKey(path, Integer.toString(rev));
        List hunks = this.cache.getHunks(key);
        Assert.assertEquals((String)"Incorrect number of hunks", (int)numHunks, (int)hunks.size());
        int numAdded = 0;
        for (Hunk hunk : hunks) {
            numAdded += hunk.getToCount() - hunk.getFromCount();
        }
        Assert.assertEquals((String)("Hunk total did not match for " + key), (int)totalAdded, (int)numAdded);
    }
}

