/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.rep.BaseTestHarness;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.perforce.P4TestHarness;
import com.cenqua.fisheye.perforce.client.DescribeProcessor;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.xmlbeans.XmlException;
import org.junit.Test;

public class DescribeTest {
    @Test
    public void testDiff() throws IOException, XmlException, ConfigException {
        String line;
        P4TestHarness testHarness = new P4TestHarness();
        testHarness.setRepoName("test");
        testHarness.setCaseSensitive(true);
        testHarness.setStoreDiffs(true);
        testHarness.setCharset(null);
        RepositoryType repoType = testHarness.createP4RepoDefinition();
        P4ScmConfig p4Config = new P4ScmConfig("test", null, (RepositorySystemType)repoType.getPerforce());
        RepositoryConfig repoConfig = new RepositoryConfig(BaseTestHarness.createMockRootConfig(), repoType, (ScmConfig)p4Config, (LicenseEnforcer)new NullLicenseEnforcer(), null);
        P4RepositoryInfo repoInfo = new P4RepositoryInfo(repoConfig);
        SortedMap<Long, P4ChangeList> changeLists = this.createChangeLists();
        DescribeProcessor processor = new DescribeProcessor(repoInfo, changeLists, DescribeProcessor.DescribeType.UNIFIED, new DiffTextCache("test", true));
        File diffFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/p4/diffs/p4descout.txt");
        BufferedReader reader = new BufferedReader(new FileReader(diffFile));
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (line.trim().length() == 0) continue;
            processor.processLine(line, count);
        }
    }

    private SortedMap<Long, P4ChangeList> createChangeLists() {
        TreeMap<Long, P4ChangeList> changeLists = new TreeMap<Long, P4ChangeList>();
        for (int i = 2873; i < 5000; ++i) {
            this.createChangeList(changeLists, i);
        }
        return changeLists;
    }

    private void createChangeList(SortedMap<Long, P4ChangeList> changeLists, long i) {
        changeLists.put(i, new P4ChangeList(i));
    }
}

