/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class CaseSensitivityTest
extends P4TestBase {
    @Override
    protected String getDumpName() {
        return "case";
    }

    @Override
    protected boolean getCaseSensitive() {
        return CaseSensitivityTest.isFilesystemCaseSensitive();
    }

    @Test
    public void testSlurp() throws Exception {
        if (!this.getCaseSensitive()) {
            Path path = new Path((CharSequence)"/dir1/dir2/test.txt");
            FileHistory history = this.cache.getFileHistory(path);
            Assert.assertEquals((String)"history size incorrect", (int)3, (int)history.getRevisions().size());
            path = new Path((CharSequence)"/dir1/Dir2/test.txt");
            history = this.cache.getFileHistory(path);
            Assert.assertEquals((String)"history size incorrect", (int)3, (int)history.getRevisions().size());
            RevInfoKey key = new RevInfoKey(new Path((CharSequence)"/DIR1/dir2/test.TXT"), "2");
            FileRevision revision = this.cache.getFileRevision(key);
            Assert.assertNotNull((String)"Revision not found", (Object)revision);
            Assert.assertEquals((String)"Path incorrect", (String)"dir1/Dir2/Test.txt", (String)revision.getPath().getPath());
            key = new RevInfoKey(new Path((CharSequence)"/DIR1/dir2/test.TXT"), "3");
            revision = this.cache.getFileRevision(key);
            Assert.assertNotNull((String)"Revision not found", (Object)revision);
            Assert.assertEquals((String)"Path incorrect", (String)"dir1/dir2/test.txt", (String)revision.getPath().getPath());
            this.assertContainsRevs("select revisions from dir / where path like \"DIR1/DIR2/TEST.TXT\"", 3, new int[]{1, 2, 3});
            RecentChangesParams2 params = new RecentChangesParams2();
            params.setBasePath(new Path((CharSequence)"DiR1/dIR2"));
            params.setMaxReturn(10);
            Map<String, ChangeSet> changeSets = this.getChangeSetMap(this.cache.findRecentChangeSets(params));
            Assert.assertEquals((String)"Unexpected results in recent test", (int)3, (int)changeSets.size());
            Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSets.containsKey("1"));
            Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSets.containsKey("2"));
            Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSets.containsKey("3"));
            Assert.assertEquals((String)this.getEngine().getBucketGraph().toStringFull(), (String)"\n cache [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 13442=[0,3] \n cache [__TRUNKLIKE__, .txt, conor] 13442=[0,3] \n cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \n cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 13442=[0,3] \n cache [head, .txt, __ALL_AUTHORS__] 13442=[0,3] \n cache [head, .txt, conor] 13442=[0,3] \n cache [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \n cache [head, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1 cache [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1 cache [__TRUNKLIKE__, .txt, conor] 13442=[0,3] \ndir1 cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1 cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1 cache [head, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1 cache [head, .txt, conor] 13442=[0,3] \ndir1 cache [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1 cache [head, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1/dir2 cache [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2 cache [__TRUNKLIKE__, .txt, conor] 13442=[0,3] \ndir1/dir2 cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2 cache [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1/dir2 cache [head, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2 cache [head, .txt, conor] 13442=[0,3] \ndir1/dir2 cache [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2 cache [head, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1/dir2/test.txt data [__TRUNKLIKE__, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2/test.txt data [__TRUNKLIKE__, .txt, conor] 13442=[0,3] \ndir1/dir2/test.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2/test.txt data [__TRUNKLIKE__, __ALL_EXTENSIONS__, conor] 13442=[0,3] \ndir1/dir2/test.txt data [head, .txt, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2/test.txt data [head, .txt, conor] 13442=[0,3] \ndir1/dir2/test.txt data [head, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 13442=[0,3] \ndir1/dir2/test.txt data [head, __ALL_EXTENSIONS__, conor] 13442=[0,3] ");
        }
    }
}

