/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.perforce.P4TestBase;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class BasicSlurpTest
extends P4TestBase {
    @Override
    protected String getDumpName() {
        return "basic";
    }

    @Override
    protected boolean getStoreDiffs() {
        return false;
    }

    @Test
    public void testSlurp() throws DbException, IOException {
        Path path = new Path((CharSequence)"/test/test.txt");
        FileHistory history = this.cache.getFileHistory(path);
        Assert.assertEquals((String)"history size incorrect", (int)2, (int)history.getRevisions().size());
        RevInfoKey key = new RevInfoKey(path, "2");
        Blame blame = this.cache.getBlame(key);
        List chunks = blame.getChunks();
        Assert.assertEquals((String)"Blame size incorrect", (int)2, (int)chunks.size());
        BlameChunk chunk1 = (BlameChunk)chunks.get(0);
        Assert.assertEquals((String)"incorrect revision", (String)"1", (String)chunk1.getRevision());
        BlameChunk chunk2 = (BlameChunk)chunks.get(1);
        Assert.assertEquals((String)"incorrect revision", (String)"2", (String)chunk2.getRevision());
    }

    @Test
    public void testContent() throws IOException, DbException {
        Path path = new Path((CharSequence)"/test/test.txt");
        this.assertContent(path, 1L, "Test file");
        this.assertContent(path, 2L, "Test file\nSecond line");
    }

    @Test
    public void testBlame() throws IOException, DbException {
        Path path = new Path((CharSequence)"/test/test.txt");
        Blame blame = this.cache.getBlame(new RevInfoKey(path, "2"));
        List chunks = blame.getChunks();
        Assert.assertEquals((String)"1", (String)((BlameChunk)chunks.get(0)).getRevision());
        Assert.assertEquals((String)"2", (String)((BlameChunk)chunks.get(1)).getRevision());
    }

    @Test
    public void testRevCounts() {
        RevCountChecker.checkRevCounts(this.getCache());
    }
}

