/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model.manager.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.dao.HibernateCommitterUserMappingDAO;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level2-dao.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateCommitterUserMappingDAOTest {
    @Autowired
    private HibernateCommitterUserMappingDAO committerUserMappingDAO;
    @Autowired
    private CurrentSessionProvider currentSessionProvider;

    @Test
    public void testAdd() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111}));
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
    }

    @Test
    public void testDelete() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        this.committerUserMappingDAO.delete(committerUserMapping111);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping112}));
        this.committerUserMappingDAO.delete(committerUserMapping112);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testList() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111}));
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping111, committerUserMapping112}));
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
    }

    @Test
    public void testListForUser() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForUser("user1"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForUser("user0"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020}));
    }

    @Test
    public void testListForUserShouldBeCaseInsensitive() throws Exception {
        CommitterUserMapping bob = new CommitterUserMapping("BOB", "repo1", "comitter1");
        CommitterUserMapping don = new CommitterUserMapping("Don", "repo1", "comitter2");
        this.committerUserMappingDAO.add(bob);
        this.committerUserMappingDAO.add(don);
        List bobs = this.committerUserMappingDAO.listForUser("bob");
        List dons = this.committerUserMappingDAO.listForUser("DON");
        List repoDons = this.committerUserMappingDAO.listForUserAndRepository("dON", "repo1");
        Assert.assertThat((Object)bobs, (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{bob}));
        Assert.assertThat((Object)dons, (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{don}));
        Assert.assertThat((Object)repoDons, (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{don}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListForUserWithUserNullThrows() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.listForUser(null);
    }

    @Test
    public void testListForRepository() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForRepository("repo1"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112, committerUserMapping010}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForRepository("repo2"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping020}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListForRepositoryWithRepositoryNullThrows() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.listForRepository(null);
    }

    @Test
    public void testListForUserAndRepository() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForUserAndRepository("user1", "repo1"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForUserAndRepository("user0", "repo2"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping020}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListForUserAndRepositoryWithUserNullThrows() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.listForUserAndRepository(null, "repo1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListForUserAndRepositoryWithRepositoryNullThrows() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.listForUserAndRepository("user1", null);
    }

    @Test
    public void testGetByRepositoryAndCommitter() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commiter1"), (Matcher)Matchers.equalTo((Object)committerUserMapping111));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commiter2"), (Matcher)Matchers.equalTo((Object)committerUserMapping112));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo2", "commiter0"), (Matcher)Matchers.equalTo((Object)committerUserMapping020));
    }

    @Test
    public void testGetByRepositoryAndCommitterIgnoreCommiterCase() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "COMMiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "COMMiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "COMMiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("user0", "repo2", "COMMiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commITER1"), (Matcher)Matchers.equalTo((Object)committerUserMapping111));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commITER2"), (Matcher)Matchers.equalTo((Object)committerUserMapping112));
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("repo2", "commITER0"), (Matcher)Matchers.equalTo((Object)committerUserMapping020));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByRepositoryAndCommitterThrowsWhenRepoNull() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.getByRepositoryAndCommitter(null, "commiter1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByRepositoryAndCommitterThrowsWhenCommiterNull() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", null);
    }

    @Test
    public void testGetByRepositoryAndCommitterReturnsNullIfNotFound() throws Exception {
        Assert.assertThat((Object)this.committerUserMappingDAO.getByRepositoryAndCommitter("nonexisting", "nonexisting"), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testDeleteForUser() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("User0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("USeR0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112}));
        this.committerUserMappingDAO.deleteForUser("USER0");
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        this.committerUserMappingDAO.deleteForUser("userNonExisting");
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping111, committerUserMapping112}));
        this.committerUserMappingDAO.deleteForUser("user1");
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testRenameUser() throws Exception {
        CommitterUserMapping committerUserMapping111 = new CommitterUserMapping("user1", "repo1", "commiter1");
        this.committerUserMappingDAO.add(committerUserMapping111);
        CommitterUserMapping committerUserMapping112 = new CommitterUserMapping("user1", "repo1", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping112);
        CommitterUserMapping committerUserMapping010 = new CommitterUserMapping("user0", "repo1", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping010);
        CommitterUserMapping committerUserMapping020 = new CommitterUserMapping("User0", "repo2", "commiter0");
        this.committerUserMappingDAO.add(committerUserMapping020);
        CommitterUserMapping committerUserMapping222 = new CommitterUserMapping("user2", "repo2", "commiter2");
        this.committerUserMappingDAO.add(committerUserMapping222);
        Assert.assertThat((Object)this.committerUserMappingDAO.list(), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMapping010, committerUserMapping020, committerUserMapping111, committerUserMapping112, committerUserMapping222}));
        this.committerUserMappingDAO.renameUser("user1", "user2");
        this.committerUserMappingDAO.renameUser("USER0", "USer3");
        this.currentSessionProvider.currentSession().flush();
        this.currentSessionProvider.currentSession().clear();
        CommitterUserMapping committerUserMappingAfterRename1 = this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commiter1");
        CommitterUserMapping committerUserMappingAfterRename2 = this.committerUserMappingDAO.getByRepositoryAndCommitter("repo1", "commiter2");
        Assert.assertThat((Object)committerUserMappingAfterRename1.getUserName(), (Matcher)Matchers.equalTo((Object)"user2"));
        Assert.assertThat((Object)committerUserMappingAfterRename2.getUserName(), (Matcher)Matchers.equalTo((Object)"user2"));
        Assert.assertThat((Object)this.committerUserMappingDAO.listForUser("user2"), (Matcher)Matchers.contains((Object[])new CommitterUserMapping[]{committerUserMappingAfterRename1, committerUserMappingAfterRename2}));
        List user3MappigsAfterRename = this.committerUserMappingDAO.listForUser("user3");
        Assert.assertThat((Object)user3MappigsAfterRename, (Matcher)Matchers.containsInAnyOrder((Object[])new CommitterUserMapping[]{committerUserMapping020, committerUserMapping010}));
        Assert.assertThat((Object)user3MappigsAfterRename, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"userName", (Matcher)Matchers.equalTo((Object)"user3"))));
    }
}

