/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.cenqua.fisheye.config1.SmtpType;
import com.cenqua.fisheye.mail.Mailer;
import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import junit.framework.Assert;

public class MailerTestUtils {
    public static final String HOST;
    public static final Integer PORT;
    public static final String TEST_LOGIN = "test";
    public static final String TEST_EMAIL = "test@test.com";
    public static final String TEST_PASSWORD = "test";
    private static final GreenMail greenmail;
    private static final int INITIAL_PORT = 6025;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer nextFreePort(int port) {
        MailerTestUtils.checkPortLegality(port);
        ServerSocket temp = null;
        try {
            temp = new ServerSocket(port);
            Integer n = port;
            return n;
        }
        catch (IOException e) {
            System.err.println("port " + port + " in use. Trying " + (port + 1) + ".");
        }
        finally {
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (IOException iOException) {}
            }
        }
        return MailerTestUtils.nextFreePort(port + 1);
    }

    private static void checkPortLegality(int port) {
        assert (port > 0);
        assert (port < 65535);
    }

    private static String localLoopback() {
        try {
            return InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }

    public static void assertCharByCharIgnoreEOLEquals(String expected, String actual) {
        char[] expectedChars = expected.trim().replaceAll("\\r\\n|\\n\\r|\\n|\\r", "").toCharArray();
        char[] actualChars = actual.trim().replaceAll("\\r\\n|\\n\\r|\\n|\\r", "").toCharArray();
        Assert.assertTrue((String)("expectedChars.length=" + expectedChars.length + " actualChars.length=" + actualChars.length + "\nexpected=[" + expected + "]\nactual=[" + actual + "]"), (expectedChars.length == actualChars.length ? 1 : 0) != 0);
        StringBuilder resultBuffer = new StringBuilder();
        for (int i = 0; i < expectedChars.length; ++i) {
            char expectedChar = expectedChars[i];
            char actualChar = actualChars[i];
            Assert.assertEquals((String)("results before fail:[" + resultBuffer.toString() + "]"), (char)expectedChar, (char)actualChar);
            resultBuffer.append(expectedChar);
        }
    }

    public static List<MailMessageData> makeEmails(boolean customSubject, String subjectIdentifier, String[] subjectLines, String[] lineSeps, String[] bodies) {
        ArrayList<MailMessageData> validEmails = new ArrayList<MailMessageData>();
        for (String subjectLine : subjectLines) {
            for (String lineSep : lineSeps) {
                for (String body : bodies) {
                    validEmails.add(MailerTestUtils.makeEmail(customSubject, subjectLine, subjectIdentifier + subjectLine + lineSep + body));
                }
            }
        }
        return validEmails;
    }

    public static MailMessageData makeEmail(boolean customSubject, String subject, String body) {
        MailMessageData message = new MailMessageData();
        message.addRecipient(TEST_EMAIL);
        message.setSubject(subject);
        message.setBodyText("text/plain; charset=UTF-8", body);
        message.setAllowCustomBodyHeaders(customSubject);
        return message;
    }

    public static int cleanInbox() throws FolderException {
        return MailerTestUtils.cleanInbox("test");
    }

    public static int cleanInbox(String username) throws FolderException {
        Managers managers = greenmail.getManagers();
        MailFolder mailFolder = managers.getImapHostManager().getInbox(managers.getUserManager().getUser(username));
        mailFolder.deleteAllMessages();
        return mailFolder.getMessageCount();
    }

    public static boolean sendEmail(MailMessageData validEmail) {
        SmtpType smtptype = SmtpType.Factory.newInstance();
        smtptype.setHost(HOST);
        smtptype.setPort(new BigInteger(PORT.toString()));
        smtptype.setUsername("test");
        smtptype.setPassword("test");
        smtptype.setFrom(TEST_EMAIL);
        Mailer mailer = new Mailer(smtptype);
        return mailer.sendMessage(validEmail);
    }

    public static boolean sendTLSEmail(MailMessageData validEmail) {
        SmtpType smtptype = SmtpType.Factory.newInstance();
        smtptype.setHost(HOST);
        smtptype.setPort(new BigInteger(PORT.toString()));
        smtptype.setUsername("test");
        smtptype.setPassword("test");
        smtptype.setFrom(TEST_EMAIL);
        smtptype.setStarttls(true);
        Mailer mailer = new Mailer(smtptype);
        return mailer.sendMessage(validEmail);
    }

    public static List<MailMessageData> makeNormalEmails(String subjectIdentifier, String[] subjectLines, String[] lineSeps, String[] bodies) {
        return MailerTestUtils.makeEmails(false, subjectIdentifier, subjectLines, lineSeps, bodies);
    }

    public static void dumpMail(MailMessageData validemail) {
        System.err.println(validemail);
    }

    public static List<MailMessageData> makeCustomSubjectEmails(String subjectIdentifier, String[] subjectLines, String[] lineSeps, String[] bodies) {
        return MailerTestUtils.makeEmails(true, subjectIdentifier, subjectLines, lineSeps, bodies);
    }

    public static void dumpMessages(Message[] messages) throws MessagingException {
        for (Message message : messages) {
            MailerTestUtils.dumpMessage(message);
        }
    }

    public static void dumpMessage(Message message) throws MessagingException {
        System.err.println("subject=[" + message.getSubject() + "]");
        System.err.println("body=[" + GreenMailUtil.getBody((Part)message) + "]");
    }

    public static GreenMail getGreenmailServer() {
        return greenmail;
    }

    static {
        PORT = MailerTestUtils.nextFreePort(6025);
        HOST = MailerTestUtils.localLoopback();
        greenmail = new GreenMail(new ServerSetup(PORT.intValue(), HOST, "smtp"));
        Runtime.getRuntime().addShutdownHook(new Thread("greenmail-shutdown"){

            @Override
            public void run() {
                greenmail.stop();
            }
        });
        greenmail.start();
    }
}

