/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.fisheye.config1.SmtpType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import java.math.BigInteger;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MailerTest {
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();

    @Test
    public void enablingDebugShouldSetMailLoggerToDebug() throws Exception {
        SmtpType smtpType = this.createSmtpType();
        Mailer mailer = new Mailer(smtpType);
        smtpType.setDebug(true);
        mailer.reload(smtpType);
        Assert.assertThat((Object)Logs.MAIL_LOG.getLevel(), (Matcher)Matchers.equalTo((Object)Level.DEBUG));
        Assert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.DEBUG), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("mail.smtp.host = localhost"))));
    }

    @Test
    public void disablingDebugShouldSetMailLoggerToInfo() throws Exception {
        SmtpType smtpType = this.createSmtpType();
        Mailer mailer = new Mailer(smtpType);
        smtpType.setDebug(false);
        Logs.MAIL_LOG.setLevel(Level.DEBUG);
        mailer.reload(smtpType);
        Assert.assertThat((Object)Logs.MAIL_LOG.getLevel(), (Matcher)Matchers.equalTo((Object)Level.INFO));
        Assert.assertThat(this.logs.getEvents(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.DEBUG))));
    }

    @After
    public void tearDown() throws Exception {
        Logs.MAIL_LOG.setLevel(null);
    }

    private SmtpType createSmtpType() {
        SmtpType smtpType = SmtpType.Factory.newInstance();
        smtpType.setHost("localhost");
        smtpType.setPort(new BigInteger("25"));
        smtpType.setUsername("aaa");
        smtpType.setPassword("bbb");
        smtpType.setFrom("from@abcd");
        return smtpType;
    }
}

