/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.cenqua.fisheye.mail.MailerTestUtils;
import com.cenqua.fisheye.util.Disposer;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class MailMessageTest {
    private GreenMail greenmail;
    private Configuration templateConfig;
    private static final long MAX_WAIT_TIME = 10000L;
    private static final String HTML_TEMPLATE = "[#ftl]\n[@compress single_line=true]\n    Subject: [ Foo ] bar:/baz\n            more subject here\n[/@compress]\n\n\n<html>\n<body>\nThis is a test</body>\n</html>";
    private static final String TEXT_TEMPLATE = "[#ftl]\nSubject: [ Foo ] bar:/baz  \n\nThis is a test";

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        this.greenmail = MailerTestUtils.getGreenmailServer();
        this.templateConfig = new Configuration();
        this.templateConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.templateConfig.setURLEscapingCharset("UTF-8");
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
    }

    @Test
    public void testTemplatedEmailNotChangedDuringTransport() throws Exception {
        this.greenmail.setUser("test@test.com", "test", "test");
        this.assertTemplatedEmailNotChangedDuringTransport(HTML_TEMPLATE);
        this.assertTemplatedEmailNotChangedDuringTransport(TEXT_TEMPLATE);
    }

    private void assertTemplatedEmailNotChangedDuringTransport(String templateContents) throws Exception {
        Template template = new Template("test", (Reader)new StringReader(templateContents), this.templateConfig, "UTF-8");
        StringWriter writer = new StringWriter();
        template.process(Collections.emptyMap(), (Writer)writer);
        MailMessageData message = new MailMessageData();
        message.addRecipient("test@test.com");
        String subject = "original, uncustomized subject";
        message.setSubject(subject);
        message.setBodyText("text/html; charset=UTF-8", writer.toString());
        MailerTestUtils.cleanInbox();
        MailerTestUtils.sendEmail(message);
        Assert.assertTrue((String)"No mail received after waiting 10000 ms", (boolean)this.greenmail.waitForIncomingEmail(10000L, 1));
        MimeMessage[] messagesRecieved = this.greenmail.getReceivedMessages();
        Assert.assertEquals((int)1, (int)messagesRecieved.length);
        MailerTestUtils.assertCharByCharIgnoreEOLEquals(writer.toString().replaceFirst("Subject:.*\\n\\n", ""), GreenMailUtil.getBody((Part)messagesRecieved[0]));
        MailerTestUtils.assertCharByCharIgnoreEOLEquals(writer.toString().substring("Subject:".length(), writer.toString().indexOf("\n")), messagesRecieved[0].getSubject());
    }
}

