/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.join.BitSetRightJoinEnum;
import com.cenqua.fisheye.lucene.join.DocumentRightJoinEnum;
import com.cenqua.fisheye.lucene.join.LeftJoinQuery;
import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Test;

public class LeftJoinQueryTest {
    private RAMDirectory leftDir = new RAMDirectory();
    private RAMDirectory rightDir = new RAMDirectory();

    @Test
    public void test1to1() throws Exception {
        String[][][] leftDocs = new String[][][]{{{"pk", "1"}, {"type", "r"}, {"name", "matt"}}, {{"pk", "2"}, {"type", "r"}, {"name", "jim"}}, {{"pk", "3"}, {"type", "r"}, {"name", "jim"}}};
        String[][][] rightDocs = new String[][][]{{{"fk", "1"}, {"age", "10"}}, {{"fk", "2"}, {"age", "10"}}, {{"fk", "3"}, {"age", "20"}}};
        this.setupDocs(this.leftDir, leftDocs);
        this.setupDocs(this.rightDir, rightDocs);
        IndexReader leftReader = IndexReader.open((Directory)this.leftDir);
        IndexSearcher leftSearcher = new IndexSearcher(leftReader);
        IndexReader rightReader = IndexReader.open((Directory)this.rightDir);
        BooleanQuery leftQ = new BooleanQuery();
        leftQ.add((Query)new TermQuery(new Term("name", "jim")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"2"}, leftSearcher, leftQ, rightReader, (Query)new TermQuery(new Term("age", "10")));
        leftQ = new BooleanQuery();
        leftQ.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "2"}, leftSearcher, leftQ, rightReader, (Query)new TermQuery(new Term("age", "10")));
        leftQ = new BooleanQuery();
        this.subtest(new String[]{"1", "2"}, leftSearcher, leftQ, rightReader, (Query)new TermQuery(new Term("age", "10")));
    }

    private void subtest(String[] expectedPKs, IndexSearcher leftSearcher, BooleanQuery leftq, IndexReader rightReader, Query rightq) throws IOException {
        BitSet bs = LuceneHelper.collectMatchingDocuments((IndexSearcher)new IndexSearcher(rightReader), (Query)rightq, null);
        this.assertQueryResults((RightJoinEnum)new DocumentRightJoinEnum(rightReader, "fk", bs), leftSearcher, leftq, expectedPKs);
        this.assertQueryResults((RightJoinEnum)new BitSetRightJoinEnum(rightReader, "fk", bs), leftSearcher, leftq, expectedPKs);
    }

    private void assertQueryResults(RightJoinEnum rightEnum, IndexSearcher leftSearcher, BooleanQuery bq, String[] expectedPKs) throws IOException {
        BooleanQuery leftq = (BooleanQuery)bq.clone();
        LeftJoinQuery ljq = new LeftJoinQuery("pk", rightEnum);
        leftq.add((Query)ljq, BooleanClause.Occur.MUST);
        TopDocs h = leftSearcher.search((Query)leftq, 1000);
        Assert.assertEquals((int)expectedPKs.length, (int)h.scoreDocs.length);
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(expectedPKs));
        for (int i = 0; i < h.scoreDocs.length; ++i) {
            Document doc = leftSearcher.doc(h.scoreDocs[i].doc);
            String pk = doc.get("pk");
            Assert.assertNotNull((Object)pk);
            Assert.assertTrue((String)pk, (boolean)expected.contains(pk));
            expected.remove(pk);
        }
        Assert.assertTrue((boolean)expected.isEmpty());
    }

    @Test
    public void testNto1() throws Exception {
        String[][][] leftDocs = new String[][][]{{{"pk", "1"}, {"type", "r"}, {"name", "matt"}}, {{"pk", "1"}, {"type", "r"}, {"name", "matty"}}, {{"pk", "2"}, {"type", "r"}, {"name", "jim"}}, {{"pk", "2"}, {"type", "r"}, {"name", "jimy"}}, {{"pk", "3"}, {"type", "r"}, {"name", "jim"}}};
        String[][][] rightDocs = new String[][][]{{{"fk", "1"}, {"age", "10"}}, {{"fk", "2"}, {"age", "10"}}, {{"fk", "3"}, {"age", "20"}}};
        this.setupDocs(this.leftDir, leftDocs);
        this.setupDocs(this.rightDir, rightDocs);
        IndexReader leftReader = IndexReader.open((Directory)this.leftDir);
        IndexSearcher leftSearcher = new IndexSearcher(leftReader);
        IndexReader rightReader = IndexReader.open((Directory)this.rightDir);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("name", "jim")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "1", "2", "2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        this.subtest(new String[]{"1", "1", "2", "2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
    }

    @Test
    public void test1toN() throws Exception {
        String[][][] leftDocs = new String[][][]{{{"pk", "1"}, {"type", "r"}, {"name", "matt"}}, {{"pk", "2"}, {"type", "r"}, {"name", "jim"}}, {{"pk", "3"}, {"type", "r"}, {"name", "jim"}}};
        String[][][] rightDocs = new String[][][]{{{"fk", "1"}, {"age", "10"}}, {{"fk", "1"}, {"age", "20"}}, {{"fk", "2"}, {"age", "10"}}, {{"fk", "3"}, {"age", "20"}}, {{"fk", "3"}, {"age", "30"}}};
        this.setupDocs(this.leftDir, leftDocs);
        this.setupDocs(this.rightDir, rightDocs);
        IndexReader leftReader = IndexReader.open((Directory)this.leftDir);
        IndexSearcher leftSearcher = new IndexSearcher(leftReader);
        IndexReader rightReader = IndexReader.open((Directory)this.rightDir);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("name", "jim")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "3"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "20")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"3"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "30")));
    }

    @Test
    public void testNtoM() throws Exception {
        String[][][] leftDocs = new String[][][]{{{"pk", "1"}, {"type", "r"}, {"name", "matt"}}, {{"pk", "1"}, {"type", "r"}, {"name", "matty"}}, {{"pk", "2"}, {"type", "r"}, {"name", "jim"}}, {{"pk", "3"}, {"type", "r"}, {"name", "jim"}}, {{"pk", "3"}, {"type", "r"}, {"name", "jimy"}}};
        String[][][] rightDocs = new String[][][]{{{"fk", "1"}, {"age", "10"}}, {{"fk", "1"}, {"age", "20"}}, {{"fk", "2"}, {"age", "10"}}, {{"fk", "3"}, {"age", "20"}}, {{"fk", "3"}, {"age", "30"}}};
        this.setupDocs(this.leftDir, leftDocs);
        this.setupDocs(this.rightDir, rightDocs);
        IndexReader leftReader = IndexReader.open((Directory)this.leftDir);
        IndexSearcher leftSearcher = new IndexSearcher(leftReader);
        IndexReader rightReader = IndexReader.open((Directory)this.rightDir);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("name", "jim")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("name", "jim")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"3"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "20")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "1", "2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "10")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"1", "1", "3", "3"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "20")));
        bq = new BooleanQuery();
        bq.add((Query)new TermQuery(new Term("type", "r")), BooleanClause.Occur.MUST);
        this.subtest(new String[]{"3", "3"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("age", "30")));
    }

    @Test
    public void testBitSetJoinCoverage() throws Exception {
        String[][][] leftDocs = new String[][][]{{{"pk", "1"}, {"name", "matt"}}, {{"pk", "2"}, {"name", "matt"}}};
        String[][][] rightDocs = new String[][][]{{{"fk", "1"}, {"type", "a"}, {"name", "matt"}}, {{"fk", "2"}, {"type", "b"}, {"name", "matt"}}, {{"fk", "1"}, {"type", "a"}, {"name", "matt"}}, {{"fk", "2"}, {"type", "b"}, {"name", "matt"}}, {{"fk", "1"}, {"type", "a"}, {"name", "matt"}}, {{"fk", "2"}, {"type", "b"}, {"name", "matt"}}};
        this.setupDocs(this.leftDir, leftDocs);
        this.setupDocs(this.rightDir, rightDocs);
        IndexReader leftReader = IndexReader.open((Directory)this.leftDir);
        IndexSearcher leftSearcher = new IndexSearcher(leftReader);
        IndexReader rightReader = IndexReader.open((Directory)this.rightDir);
        BooleanQuery bq = new BooleanQuery();
        this.subtest(new String[]{"2"}, leftSearcher, bq, rightReader, (Query)new TermQuery(new Term("type", "b")));
    }

    void setupDocs(RAMDirectory dir, String[][][] docs) throws Exception {
        IndexWriter w = new DefaultIndexWriterFactory().create((Directory)dir, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        for (String[][] doc : docs) {
            Document document = new Document();
            for (String[] row : doc) {
                document.add((Fieldable)LuceneHelper.Keyword((String)row[0], (String)row[1]));
            }
            w.addDocument(document);
        }
        w.close();
    }
}

