/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.join.LeftJoinQuery;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.util.Timer;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class JoinStressTester {
    private IndexReader rightReader;
    private IndexSearcher rightSearcher;
    private IndexReader leftReader;
    private IndexSearcher leftSearcher;
    public static final int NKEYS = 100;
    public static final int NTIMES_L = 3;
    public static final int NTIMES_R = 10200;
    File leftFile;
    File rightFile;
    Directory leftDir;
    Directory rightDir;

    static void visitKeyspace(KeySpaceVisitor v, boolean visitLeftRight, Timer t) throws IOException {
        long t0 = System.currentTimeMillis();
        long pause = 10000L;
        if (t != null) {
            t.mark("generating 3-10200");
        }
        int nskip = 1;
        for (int n = 0; n < 3; n += nskip) {
            if (n == 10) {
                nskip = 11;
            } else if (n > 150) {
                nskip = n;
            }
            int mskip = 1;
            for (int m = 0; m < 10200; m += mskip) {
                if (m == 10) {
                    mskip = 11;
                } else if (m > 150) {
                    mskip = m;
                }
                String rel = n + "-" + m;
                long t1 = System.currentTimeMillis();
                if (t != null && t0 + pause < t1) {
                    t.mark("currently at " + rel);
                    t0 = t1;
                }
                for (int key = 0; key < 100; ++key) {
                    int i;
                    String pk = rel + "_" + key;
                    v.visit(pk, key, n, m);
                    if (!visitLeftRight) continue;
                    for (i = 0; i < n; ++i) {
                        v.visitLeft(pk, key, n, m);
                    }
                    for (i = 0; i < m; ++i) {
                        v.visitRight(pk, key, n, m);
                    }
                }
            }
        }
    }

    public void setUp() throws Exception {
        this.leftFile = new File(FisheyeTestUtil.getTmpDir(), "joinstresstest-leftdir");
        this.rightFile = new File(FisheyeTestUtil.getTmpDir(), "joinstresstest-righttdir");
        if (!this.leftFile.isDirectory() || !this.rightFile.isDirectory()) {
            this.makeIndices();
        } else {
            this.leftDir = FSDirectory.open((File)this.leftFile);
            this.rightDir = FSDirectory.open((File)this.rightFile);
        }
        this.rightReader = IndexReader.open((Directory)this.rightDir);
        this.rightSearcher = new IndexSearcher(this.rightReader);
        this.leftReader = IndexReader.open((Directory)this.leftDir);
        this.leftSearcher = new IndexSearcher(this.leftReader);
    }

    private void makeIndices() throws Exception {
        this.leftFile.mkdirs();
        this.rightFile.mkdirs();
        Timer t = new Timer("setup: ");
        this.leftDir = FSDirectory.open((File)this.leftFile);
        this.rightDir = FSDirectory.open((File)this.rightFile);
        RAMDirectory ld = new RAMDirectory();
        RAMDirectory rd = new RAMDirectory();
        final IndexWriter lw = new DefaultIndexWriterFactory().create((Directory)ld, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        final IndexWriter rw = new DefaultIndexWriterFactory().create((Directory)rd, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        class MyKeySpaceVisitor
        implements KeySpaceVisitor {
            int ldocs = 0;
            int rdocs = 0;

            MyKeySpaceVisitor() {
            }

            @Override
            public void visit(String pk, int key, int n, int m) throws IOException {
            }

            @Override
            public void visitLeft(String pk, int key, int n, int m) throws IOException {
                Document d = new Document();
                d.add((Fieldable)LuceneHelper.Keyword((String)"pk", (String)pk));
                d.add((Fieldable)LuceneHelper.Keyword((String)"n", (String)("" + n)));
                d.add((Fieldable)LuceneHelper.Keyword((String)"m", (String)("" + m)));
                d.add((Fieldable)LuceneHelper.Keyword((String)"key", (String)("" + key)));
                lw.addDocument(d);
                ++this.ldocs;
            }

            @Override
            public void visitRight(String pk, int key, int n, int m) throws IOException {
                Document d = new Document();
                d.add((Fieldable)LuceneHelper.Keyword((String)"fk", (String)pk));
                d.add((Fieldable)LuceneHelper.Keyword((String)"n", (String)("" + n)));
                d.add((Fieldable)LuceneHelper.Keyword((String)"m", (String)("" + m)));
                d.add((Fieldable)LuceneHelper.Keyword((String)"key", (String)("" + key)));
                rw.addDocument(d);
                ++this.rdocs;
            }
        }
        MyKeySpaceVisitor v = new MyKeySpaceVisitor();
        JoinStressTester.visitKeyspace(v, true, t);
        t.mark("created RAM index, ldocs=" + v.ldocs + " rdocs=" + v.rdocs);
        lw.forceMerge(1, true);
        lw.close();
        rw.forceMerge(1, true);
        rw.close();
        this.copyInto((Directory)ld, this.leftDir);
        this.copyInto((Directory)rd, this.rightDir);
        t.mark("created disk dirs at " + this.leftFile + " and " + this.rightFile);
    }

    private void copyInto(Directory src, Directory dest) throws Exception {
        IndexWriter w = new DefaultIndexWriterFactory().create(dest, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        w.addIndexes(new IndexReader[]{IndexReader.open((Directory)src)});
        w.close();
    }

    public void test1to1() throws Exception {
        class MyKeySpaceVisitor
        implements KeySpaceVisitor {
            MyKeySpaceVisitor() {
            }

            @Override
            public void visit(String pk, int key, int n, int m) throws IOException {
                if (key != 0) {
                    return;
                }
                JoinStressTester.this.subtests(pk, n, m, key);
            }

            @Override
            public void visitLeft(String pk, int key, int n, int m) throws IOException {
            }

            @Override
            public void visitRight(String pk, int key, int n, int m) throws IOException {
            }
        }
        MyKeySpaceVisitor v = new MyKeySpaceVisitor();
        for (int i = 0; i < 2; ++i) {
            this.subtests("0-0_0", 0, 0, 0);
            this.subtests("1-1_0", 1, 1, 0);
            this.subtests("2-9792_0", 2, 9792, 0);
        }
    }

    private void subtests(String pk, int n, int m, int key) throws IOException {
        System.out.println("for " + pk);
        this.subtest1(pk, n, m);
        this.subtest2(key);
        this.subtest3(m);
    }

    private void subtest1(String pk, int n, int m) throws IOException {
        long t0 = System.currentTimeMillis();
        BitSet bs = LuceneHelper.collectMatchingDocuments((IndexSearcher)this.rightSearcher, (Query)new TermQuery(new Term("fk", pk)), null);
        LeftJoinQuery q = new LeftJoinQuery("pk", this.rightReader, "fk", bs);
        long t1 = System.currentTimeMillis();
        int count = LuceneHelper.countMatchingDocuments((IndexSearcher)this.leftSearcher, (Query)q);
        long t2 = System.currentTimeMillis();
        if (m == 0) {
            Assert.assertEquals((int)0, (int)count);
        } else {
            Assert.assertEquals((int)n, (int)count);
        }
        System.out.println(" 1 times " + (t1 - t0) + " " + (t2 - t1));
    }

    private void subtest2(int key) throws IOException {
        TermQuery keyq = new TermQuery(new Term("key", "" + key));
        long t0 = System.currentTimeMillis();
        BitSet bs = LuceneHelper.collectMatchingDocuments((IndexSearcher)this.rightSearcher, (Query)keyq, null);
        LeftJoinQuery q = new LeftJoinQuery("pk", this.rightReader, "fk", bs);
        long t1 = System.currentTimeMillis();
        int count = LuceneHelper.countMatchingDocuments((IndexSearcher)this.leftSearcher, (Query)q);
        long t2 = System.currentTimeMillis();
        System.out.println(" 2 times " + (t1 - t0) + " " + (t2 - t1));
    }

    private void subtest3(int m) throws IOException {
        TermQuery keyq = new TermQuery(new Term("m", "" + m));
        long t0 = System.currentTimeMillis();
        BitSet bs = LuceneHelper.collectMatchingDocuments((IndexSearcher)this.rightSearcher, (Query)keyq, null);
        LeftJoinQuery q = new LeftJoinQuery("pk", this.rightReader, "fk", bs);
        long t1 = System.currentTimeMillis();
        int count = LuceneHelper.countMatchingDocuments((IndexSearcher)this.leftSearcher, (Query)q);
        long t2 = System.currentTimeMillis();
        System.out.println(" 3 times " + (t1 - t0) + " " + (t2 - t1));
    }

    static interface KeySpaceVisitor {
        public void visit(String var1, int var2, int var3, int var4) throws IOException;

        public void visitLeft(String var1, int var2, int var3, int var4) throws IOException;

        public void visitRight(String var1, int var2, int var3, int var4) throws IOException;
    }
}

