/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.File;
import java.util.BitSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class DocVersusEnumRacer {
    public static final int MAX = 16384;

    public static void main(String[] args) throws Exception {
        File d = FisheyeTestUtil.createTempDir("docracer");
        SimpleFSDirectory simpleFSDir = new SimpleFSDirectory(d);
        IndexWriter w = new DefaultIndexWriterFactory().create((Directory)simpleFSDir, (Analyzer)new StandardAnalyzer(LuceneConnection.VERSION), true);
        int x = 1;
        while (x < 16384) {
            String field = "f" + x;
            for (int i = 0; i < x; ++i) {
                Document doc = new Document();
                doc.add((Fieldable)LuceneHelper.Keyword((String)field, (String)field));
                w.addDocument(doc);
            }
            x = DocVersusEnumRacer.inc(x);
        }
        w.forceMerge(1, true);
        w.close();
        IndexReader r = IndexReader.open((Directory)simpleFSDir);
        int x2 = 1;
        while (x2 < 16384) {
            long td = DocVersusEnumRacer.raceDocuments(r, x2);
            long te = DocVersusEnumRacer.raceEnum(r, x2);
            System.out.println("x=" + x2 + " " + td + " " + te);
            x2 = DocVersusEnumRacer.inc(x2);
        }
    }

    private static long raceEnum(IndexReader r, int x) throws Exception {
        String field = "f" + x;
        TermEnum termEnum = r.terms(new Term(field, ""));
        long t0 = System.currentTimeMillis();
        Term t = termEnum.term();
        while (t != null && field.equals(t.field()) && termEnum.next()) {
            t = termEnum.term();
        }
        long t1 = System.currentTimeMillis();
        termEnum.close();
        return t1 - t0;
    }

    private static long raceDocuments(IndexReader r, int x) throws Exception {
        String field = "f" + x;
        BitSet bs = LuceneHelper.collectMatchingDocuments((IndexSearcher)new IndexSearcher(r), (Query)new TermQuery(new Term(field, field)), null);
        long t0 = System.currentTimeMillis();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Document document = r.document(i);
            i = bs.nextSetBit(i + 1);
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static int inc(int x) {
        return x * 2;
    }
}

