/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.filenames;

import com.cenqua.fisheye.lucene.filenames.FilenameAnalyser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.junit.Assert;
import org.junit.Test;

public class FilenameAnalyserTest {
    private static final String[][] EXPECTED_WITH_REPLACE = new String[][]{{"myfile.txt", "myfile"}, {"myfile", "myfile"}, {"myfile.properties", "myfile"}};
    private static final Object[][] EXPECTED_WITHOUT_REPLACE = new Object[][]{{"myfile.txt", new String[]{"myfile.txt", "myfile"}}, {"myfile.", new String[]{"myfile.", "myfile"}}, {"myfile", new String[]{"myfile"}}, {"myfile.properties", new String[]{"myfile.properties", "myfile"}}};

    @Test
    public void testTokenStreamWithReplace() throws Exception {
        FilenameAnalyser analyzer = new FilenameAnalyser(true);
        for (String[] testdata : EXPECTED_WITH_REPLACE) {
            TokenStream stream = analyzer.tokenStream("field", (Reader)new StringReader(testdata[0]));
            this.assertStreamEquals(stream, testdata[1]);
        }
    }

    @Test
    public void testTokenStreamWithoutReplace() throws Exception {
        FilenameAnalyser analyzer = new FilenameAnalyser(false);
        for (Object[] testdata : EXPECTED_WITHOUT_REPLACE) {
            TokenStream stream = analyzer.tokenStream("field", (Reader)new StringReader((String)testdata[0]));
            this.assertStreamEquals(stream, (String[])testdata[1]);
        }
    }

    private void assertStreamEquals(TokenStream stream, String ... expectedTokens) throws IOException {
        TermAttribute attribute = (TermAttribute)stream.getAttribute(TermAttribute.class);
        for (String token : expectedTokens) {
            Assert.assertTrue((String)("expected token: " + token), (boolean)stream.incrementToken());
            Assert.assertEquals((Object)token, (Object)attribute.term());
        }
        Assert.assertFalse((String)("Unexpected token: " + attribute.term()), (boolean)stream.incrementToken());
    }
}

