/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.camelcases.CamelCaseTokenizer;
import com.cenqua.fisheye.lucene.camelcases.Subword;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CamelCaseTokenizerTest {
    private static final String[][] SUBWORDS = new String[][]{{"AbstractLUCENEFactory3", "Abstract", "LUCENE", "Factory", "3"}, {"XY&Z Corporation - xyz@abc", "XY", "Z", "Corporation", "xyz", "abc"}, {"index-all", "index", "all"}, {"fileNameTest", "file", "Name", "Test"}, {"filename", "filename"}, {"FileNameTest", "File", "Name", "Test"}, {"FileNTest", "File", "N", "Test"}, {"FileNATest", "File", "NA", "Test"}, {"FileNAMETest", "File", "NAME", "Test"}, {"File Name Test", "File", "Name", "Test"}, {"getLDAPConfig", "get", "LDAP", "Config"}, {"AbstractLuceneFactory", "Abstract", "Lucene", "Factory"}, {"AbstractLuceneFactory3", "Abstract", "Lucene", "Factory", "3"}, {"AbstractLuceneFactory3456", "Abstract", "Lucene", "Factory", "3456"}, {"AbstractLucene3Factory", "Abstract", "Lucene", "3", "Factory"}, {"AbstractLucene356Factory", "Abstract", "Lucene", "356", "Factory"}, {"Lucene3", "Lucene", "3"}, {"Lucene30", "Lucene", "30"}, {"Lucene301", "Lucene", "301"}, {"3Lucene", "3", "Lucene"}, {"3FileNameTest", "3", "File", "Name", "Test"}, {"3fileNameTest", "3", "file", "Name", "Test"}, {"file3NameTest", "file", "3", "Name", "Test"}, {"fileName3Test", "file", "Name", "3", "Test"}, {"fileNameTest3", "file", "Name", "Test", "3"}};
    private static final Object[][] SUBWORDS_WITH_OFFSETS = new Object[][]{{"index-all", new Subword(0, 5, "index"), new Subword(6, 9, "all")}, {"filename", new Subword(0, 8, "filename")}, {"FileNameTest", new Subword(0, 4, "File"), new Subword(4, 8, "Name"), new Subword(8, 12, "Test")}, {"FileNAMETest", new Subword(0, 4, "File"), new Subword(4, 8, "NAME"), new Subword(8, 12, "Test")}, {"FileNameTEST", new Subword(0, 4, "File"), new Subword(4, 8, "Name"), new Subword(8, 12, "TEST")}, {"File Name Test", new Subword(0, 4, "File"), new Subword(5, 9, "Name"), new Subword(10, 14, "Test")}, {"Lucene3", new Subword(0, 6, "Lucene"), new Subword(6, 7, "3")}, {"Lucene30", new Subword(0, 6, "Lucene"), new Subword(6, 8, "30")}, {"30Lucene", new Subword(0, 2, "30"), new Subword(2, 8, "Lucene")}, {"AbstractLUCENEFactory3", new Subword(0, 8, "Abstract"), new Subword(8, 14, "LUCENE"), new Subword(14, 21, "Factory"), new Subword(21, 22, "3")}, {"AbstractLuceneFactory", new Subword(0, 8, "Abstract"), new Subword(8, 14, "Lucene"), new Subword(14, 21, "Factory")}, {"AbstractLuceneFactory3", new Subword(0, 8, "Abstract"), new Subword(8, 14, "Lucene"), new Subword(14, 21, "Factory"), new Subword(21, 22, "3")}, {"AbstractLucene2Factory", new Subword(0, 8, "Abstract"), new Subword(8, 14, "Lucene"), new Subword(14, 15, "2"), new Subword(15, 22, "Factory")}};
    private static final String[][] SUBWORDS_WITH_EXTENSIONS = new String[][]{{"filename.txt", "filename", ".txt"}, {"fileName.txt", "file", "Name", ".txt"}, {"FileName.txt", "File", "Name", ".txt"}, {"Filename.txt", "Filename", ".txt"}, {"index-all.txt", "index", "all", ".txt"}, {".properties", ".properties"}, {".10", ".10"}, {"properties.", "properties"}};
    private final CamelCaseTokenizer TOKENIZER = new CamelCaseTokenizer();

    @Test
    public void testGenerateSubWords() {
        this.checkTokenizer(SUBWORDS, true);
    }

    @Test
    public void testGenerateSubWordsWithOffsets() {
        this.checkTokenizer(SUBWORDS_WITH_OFFSETS, false);
    }

    @Test
    public void testGenerateSubWordsWithExtensions() {
        this.checkTokenizer(SUBWORDS_WITH_EXTENSIONS, true);
    }

    private void checkTokenizer(Object[][] data, boolean onlyCheckText) {
        for (Object[] testdata : data) {
            String word = (String)testdata[0];
            LinkedList subwords = this.TOKENIZER.findSubWords(word);
            this.assertEqualSubWords(word, subwords, testdata, onlyCheckText);
        }
    }

    private void assertEqualSubWords(String word, List<Subword> subwords, Object[] testdata, boolean onlyCheckText) {
        int i = 1;
        for (Subword subword : subwords) {
            if (onlyCheckText) {
                Assert.assertEquals((String)("Mismatch for " + word + " (generated subwords: " + subwords + ')'), (Object)testdata[i++], (Object)subword.getText());
                continue;
            }
            Assert.assertEquals((String)("Mismatch for " + word), (Object)testdata[i++], (Object)subword);
        }
    }
}

