/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.TokenStreamTestUtils;
import com.cenqua.fisheye.lucene.camelcases.CamelCaseFilter;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.junit.Test;

public class CamelCaseFilterTest {
    private static final Object[][] EXPECTED = new Object[][]{{"CamelCase.java", new String[]{"Camel", "Case", ".java"}}, {"CamelCase%java", new String[]{"Camel", "Case", "java"}}, {"CamelCase-java", new String[]{"Camel", "Case", "java"}}, {"Cam#elCase+java", new String[]{"Cam", "el", "Case", "java"}}, {"camel%&^%Case+%$java", new String[]{"camel", "Case", "java"}}, {"POJO.java", new String[]{"POJO", ".java"}}, {"getTOKEN", new String[]{"get", "TOKEN"}}, {"TOKENAnalyser", new String[]{"TOKEN", "Analyser"}}, {"setTOKENStream", new String[]{"set", "TOKEN", "Stream"}}, {"m_analyser", new String[]{"m", "analyser"}}};
    private static final Object[][] EXPECTED_WITH_OFFSETS = new Object[][]{{"TokenStreamFACTORY.java", new int[]{0, 5, 5, 11, 11, 18, 18, 23}}, {"AbstractLuceneFactory.java", new int[]{0, 8, 8, 14, 14, 21, 21, 26}}, {"AbstractLucene.java", new int[]{0, 8, 8, 14, 14, 19}}, {"Abstract%Lucene%java", new int[]{0, 8, 9, 15, 16, 20}}, {"Abstract$#%Lucene%java", new int[]{0, 8, 11, 17, 18, 22}}, {"AbstractLucene", new int[]{0, 8, 8, 14}}, {"Abstractlucene", new int[]{0, 14}}, {"Abstract", new int[]{0, 8}}};

    @Test
    public void testTokenStream() throws Exception {
        for (Object[] testdata : EXPECTED) {
            String word = (String)testdata[0];
            String[] expectedTokens = (String[])testdata[1];
            CamelCaseFilter stream = new CamelCaseFilter((TokenStream)new KeywordTokenizer((Reader)new StringReader(word)));
            TokenStreamTestUtils.assertStreamEquals((TokenStream)stream, word, expectedTokens);
        }
    }

    @Test
    public void testTokenStreamOffsets() throws Exception {
        for (Object[] testdata : EXPECTED_WITH_OFFSETS) {
            String word = (String)testdata[0];
            int[] expectedOffsets = (int[])testdata[1];
            CamelCaseFilter stream = new CamelCaseFilter((TokenStream)new KeywordTokenizer((Reader)new StringReader(word)));
            TokenStreamTestUtils.assertOffsetEquals((TokenStream)stream, word, expectedOffsets, true);
        }
    }
}

