/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.TokenStreamTestUtils;
import com.cenqua.fisheye.lucene.camelcases.CamelCaseCombinationFilter;
import com.cenqua.fisheye.lucene.camelcases.EmptyTokenStream;
import com.cenqua.fisheye.lucene.camelcases.Subword;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.junit.Test;

public class CamelCaseCombinationFilterTest {
    private static final Object[][] EXPECTED = new Object[][]{{"CamelCase.java", new String[]{"CamelCase", "CamelCase.java", "Case.java"}}, {"AbstractLuceneFactory.java", new String[]{"AbstractLucene", "AbstractLuceneFactory", "AbstractLuceneFactory.java", "LuceneFactory", "LuceneFactory.java", "Factory.java"}}, {"getTOKEN", new String[]{"getTOKEN"}}, {"TOKENAnalyser", new String[]{"TOKENAnalyser"}}, {"setTOKENStream", new String[]{"setTOKEN", "setTOKENStream", "TOKENStream"}}, {"m_analyser", new String[]{"manalyser"}}, {"analyser", new String[0]}};
    private static final Object[][] EXPECTED_WITH_OFFSETS = new Object[][]{{"TokenStreamFACTORY.java", new int[]{0, 11, 0, 18, 0, 23, 5, 18, 5, 23, 11, 23}}, {"AbstractLuceneFactory.java", new int[]{0, 14, 0, 21, 0, 26, 8, 21, 8, 26, 14, 26}}, {"AbstractLucene.java", new int[]{0, 14, 0, 19, 8, 19}}, {"AbstractLucene", new int[]{0, 14}}, {"Abstractlucene", new int[0]}, {"Abstract", new int[0]}};

    @Test
    public void testTokenStream() throws Exception {
        CamelCaseCombinationFilter combinationFilter = new CamelCaseCombinationFilter((TokenStream)new EmptyTokenStream());
        for (Object[] testdata : EXPECTED) {
            String word = (String)testdata[0];
            Object[] expectedTokens = (String[])testdata[1];
            Iterator combinations = combinationFilter.getSubWords(word).iterator();
            for (String string : expectedTokens) {
                Assert.assertTrue((String)("Expected token " + string + " was not found" + " (expected stream: " + Arrays.toString(expectedTokens) + ')'), (boolean)combinations.hasNext());
                Assert.assertEquals((String)string, (String)((Subword)combinations.next()).getText());
            }
        }
    }

    @Test
    public void testTokenStreamOffsets() throws Exception {
        for (Object[] testdata : EXPECTED_WITH_OFFSETS) {
            String word = (String)testdata[0];
            int[] expectedOffsets = (int[])testdata[1];
            CamelCaseCombinationFilter stream = new CamelCaseCombinationFilter((TokenStream)new KeywordTokenizer((Reader)new StringReader(word)));
            TokenStreamTestUtils.assertOffsetEquals((TokenStream)stream, word, expectedOffsets, true);
        }
    }
}

